/*
 * Decompiled with CFR 0.152.
 */
package fr.breadeater.javaphp;

import fr.breadeater.javaphp.JavaPHPUtils;
import fr.breadeater.javaphp.Request;
import fr.breadeater.javaphp.Response;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class JavaPHP {
    private static ExecutorService threadPool = Executors.newCachedThreadPool();
    private SocketChannel socketChannel = SocketChannel.open(StandardProtocolFamily.INET);
    private Consumer<Exception> onError = null;
    private InetSocketAddress address;
    private File unixSocketFile;
    private boolean useThreadPool = false;

    public JavaPHP(InetSocketAddress address) throws Exception {
        this.address = address;
    }

    public void useThreadPool(boolean useThreadPool) {
        this.useThreadPool = useThreadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        JavaPHP.threadPool = threadPool;
    }

    public void useUnixSocket(File unixSocketFile) throws IllegalAccessException, IOException {
        String osname = System.getProperty("os.name").toLowerCase();
        String user = System.getProperty("user.name");
        if (!osname.contains("linux")) {
            throw new UnsupportedOperationException("Unix Socket cannot be used on other Operating Systems than Linux/WSL !");
        }
        if (!user.equals("root")) {
            throw new IllegalAccessException("Unix Socket requires root privileges !");
        }
        this.socketChannel = SocketChannel.open(StandardProtocolFamily.UNIX);
        this.unixSocketFile = unixSocketFile;
    }

    public void onError(Consumer<Exception> callback) {
        this.onError = callback;
    }

    public Response run(Options options, Request request) throws Exception {
        Callable<Response> runLogic = () -> {
            try {
                Map<String, String> fastCGIheaders = JavaPHPUtils.setFastCGIParams(options, request);
                String reqbody = "";
                if (request.body != null) {
                    reqbody = request.body;
                }
                if (this.unixSocketFile != null) {
                    if (!this.unixSocketFile.exists()) {
                        throw new IllegalArgumentException("Unix Socket path is invalid or does not exists (file name must be formatted like this: phpX.X-fpm.sock) !");
                    }
                    this.socketChannel.connect(UnixDomainSocketAddress.of(this.unixSocketFile.getCanonicalPath()));
                } else {
                    this.socketChannel.connect(this.address);
                }
                this.socketChannel.write(JavaPHPUtils.buildRequest());
                this.socketChannel.write(JavaPHPUtils.buildParams(false, fastCGIheaders));
                this.socketChannel.write(JavaPHPUtils.buildParams(true, fastCGIheaders));
                this.socketChannel.write(JavaPHPUtils.buildStdin(reqbody.getBytes()));
                this.socketChannel.write(JavaPHPUtils.buildStdin(new byte[0]));
                BufferedReader responseReader = JavaPHPUtils.parseFastCGIRequest(this.socketChannel);
                return JavaPHPUtils.parseResponse(responseReader);
            }
            catch (Exception err) {
                if (this.onError != null) {
                    this.onError.accept(err);
                }
                return null;
            }
        };
        if (this.useThreadPool) {
            return threadPool.submit(runLogic).get();
        }
        return runLogic.call();
    }

    public static class Options {
        String PHP_FILEPATH;
        String PHP_DOC_ROOT;
        String PHP_SERVERADDR;
        String PHP_SERVERSOFTWARE;
        int PHP_SERVERPORT;

        public Options setPHPDocumentRoot(String php_docroot) {
            this.PHP_DOC_ROOT = php_docroot;
            return this;
        }

        public Options setPHPFilepath(String php_filepath) {
            this.PHP_FILEPATH = php_filepath;
            return this;
        }

        public Options setPHPServerAddress(String php_serveraddr) {
            this.PHP_SERVERADDR = php_serveraddr;
            return this;
        }

        public Options setPHPServerPort(int php_serverport) {
            this.PHP_SERVERPORT = php_serverport;
            return this;
        }

        public Options setPHPServerSoftwareName(String php_serversoftware) {
            this.PHP_SERVERSOFTWARE = php_serversoftware;
            return this;
        }
    }
}

