/*
 * Decompiled with CFR 0.152.
 */
package fr.breadeater.javaphp;

import com.sun.net.httpserver.Headers;
import fr.breadeater.javaphp.JavaPHP;
import fr.breadeater.javaphp.Request;
import fr.breadeater.javaphp.Response;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class JavaPHPUtils {
    JavaPHPUtils() {
    }

    protected static byte[] buildRecord(int type, byte[] content) {
        int length = content.length;
        int padding = (8 - length % 8) % 8;
        ByteBuffer buffer = ByteBuffer.allocate(8 + length + padding);
        buffer.put((byte)1);
        buffer.put((byte)type);
        buffer.putShort((short)1);
        buffer.putShort((short)length);
        buffer.put((byte)padding);
        buffer.put((byte)0);
        buffer.put(content);
        if (padding > 0) {
            buffer.put(new byte[padding]);
        }
        return buffer.array();
    }

    protected static byte[] encodeLength(int length) {
        if (length < 128) {
            return new byte[]{(byte)length};
        }
        return new byte[]{(byte)(length >> 24 | 0x80), (byte)(length >> 16), (byte)(length >> 8), (byte)length};
    }

    protected static ByteBuffer buildParams(boolean empty, Map<String, String> params) throws Exception {
        if (empty) {
            return ByteBuffer.wrap(JavaPHPUtils.buildRecord(4, new byte[0]));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            out.write(JavaPHPUtils.encodeLength(key.getBytes(StandardCharsets.UTF_8).length));
            out.write(JavaPHPUtils.encodeLength(value.getBytes(StandardCharsets.UTF_8).length));
            out.write(key.getBytes(StandardCharsets.UTF_8));
            out.write(value.getBytes(StandardCharsets.UTF_8));
        }
        return ByteBuffer.wrap(JavaPHPUtils.buildRecord(4, out.toByteArray()));
    }

    protected static ByteBuffer buildRequest() {
        byte[] body = new byte[8];
        body[0] = 0;
        body[1] = 1;
        body[2] = 0;
        return ByteBuffer.wrap(JavaPHPUtils.buildRecord(1, body));
    }

    protected static ByteBuffer buildStdin(byte[] content) {
        return ByteBuffer.wrap(JavaPHPUtils.buildRecord(5, content));
    }

    protected static BufferedReader parseFastCGIRequest(SocketChannel client) throws Exception {
        String result = "";
        InputStream in = Channels.newInputStream(client);
        while (client.isOpen()) {
            int version = in.read();
            int type = in.read();
            int requestIdHigh = in.read();
            int requestIdLow = in.read();
            int contentLengthHigh = in.read();
            int contentLengthLow = in.read();
            int padding = in.read();
            in.read();
            if (version == -1) break;
            int contentLength = contentLengthHigh << 8 | contentLengthLow;
            byte[] content = in.readNBytes(contentLength);
            if (padding > 0) {
                in.skip(padding);
            }
            if (type == 6 && contentLength > 0) {
                result = new String(content, StandardCharsets.UTF_8);
                client.close();
                break;
            }
            if (type != 3) continue;
            client.close();
            break;
        }
        return new BufferedReader(new CharArrayReader(result.toCharArray()));
    }

    protected static Map<String, String> setFastCGIParams(JavaPHP.Options runOptions, Request request) {
        HashMap<String, String> fastCGIheaders = new HashMap<String, String>();
        Headers reqHeaders = request.headers;
        String httpsEnabled = "off";
        String[] splittedURI = request.path.split("\\?", 2);
        if (splittedURI.length == 2) {
            fastCGIheaders.put("QUERY_STRING", splittedURI[1]);
        }
        if (request.https) {
            httpsEnabled = "on";
        }
        fastCGIheaders.put("SCRIPT_FILENAME", runOptions.PHP_FILEPATH);
        fastCGIheaders.put("GATEWAY_INTERFACE", "CGI/1.1");
        fastCGIheaders.put("SERVER_PROTOCOL", request.httpVersion);
        fastCGIheaders.put("REQUEST_METHOD", request.method);
        fastCGIheaders.put("SCRIPT_NAME", splittedURI[0]);
        fastCGIheaders.put("REQUEST_URI", request.path);
        fastCGIheaders.put("DOCUMENT_ROOT", runOptions.PHP_DOC_ROOT);
        fastCGIheaders.put("SERVER_SOFTWARE", runOptions.PHP_SERVERSOFTWARE);
        fastCGIheaders.put("REMOTE_ADDR", request.address.getHostName());
        fastCGIheaders.put("REMOTE_PORT", Integer.toString(request.address.getPort()));
        fastCGIheaders.put("SERVER_ADDR", runOptions.PHP_SERVERADDR);
        fastCGIheaders.put("SERVER_PORT", Integer.toString(runOptions.PHP_SERVERPORT));
        fastCGIheaders.put("HTTPS", httpsEnabled);
        for (Map.Entry<String, List<String>> entry : reqHeaders.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue().get(0);
            if (key.equals("Content-Length")) continue;
            if (key.equals("Content-Type")) {
                fastCGIheaders.put("CONTENT_TYPE", value);
                continue;
            }
            if (request.body != null) {
                int reqBodyLength = request.body.getBytes().length;
                fastCGIheaders.put("CONTENT_LENGTH", Integer.toString(reqBodyLength));
                continue;
            }
            fastCGIheaders.put("HTTP_" + key.replaceAll("-", "_").toUpperCase(), value);
        }
        return fastCGIheaders;
    }

    protected static Response parseResponse(BufferedReader reader) throws IOException {
        String line;
        StringBuilder body = new StringBuilder();
        Headers headers = new Headers();
        AtomicInteger status = new AtomicInteger(200);
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty()) {
                String bodyLine;
                while ((bodyLine = reader.readLine()) != null) {
                    body.append(bodyLine).append("\r\n");
                }
                break;
            }
            String[] splitheader = line.split(": ", 2);
            headers.add(splitheader[0], splitheader[1]);
        }
        headers.forEach((name, value) -> {
            if (name.equals("Status")) {
                String[] splitStatus = ((String)value.get(0)).split(" ");
                status.set(Integer.parseInt(splitStatus[0]));
            }
        });
        headers.remove("Status");
        return new Response(headers, body.toString(), status.get());
    }
}

