/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block;

import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import toughasnails.api.blockentity.TANBlockEntityTypes;
import toughasnails.api.particle.TANParticles;
import toughasnails.block.entity.ThermoregulatorBlockEntity;

public class ThermoregulatorBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty COOLING = BooleanProperty.m_61465_((String)"cooling");
    public static final BooleanProperty HEATING = BooleanProperty.m_61465_((String)"heating");
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;

    public ThermoregulatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)COOLING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HEATING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_(state.m_60750_(worldIn, pos));
        return InteractionResult.CONSUME;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ThermoregulatorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : ThermoregulatorBlock.m_152132_(type, TANBlockEntityTypes.THERMOREGULATOR, ThermoregulatorBlockEntity::serverTick);
    }

    public static ToIntFunction<BlockState> lightLevel(int level) {
        return state -> {
            boolean cooling = (Boolean)state.m_61143_((Property)COOLING);
            boolean heating = (Boolean)state.m_61143_((Property)HEATING);
            return ((cooling ? 1 : 0) + (heating ? 1 : 0)) * level;
        };
    }

    public BlockState m_5573_(BlockPlaceContext $$0) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)$$0.m_8125_().m_122424_())).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public BlockState m_6843_(BlockState $$0, Rotation $$1) {
        return (BlockState)$$0.m_61124_((Property)FACING, (Comparable)$$1.m_55954_((Direction)$$0.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState $$0, Mirror $$1) {
        return $$0.m_60717_($$1.m_54846_((Direction)$$0.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, COOLING, HEATING, ENABLED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean $$4) {
        ThermoregulatorBlock.dropContentsOnDestroy(state, newState, level, pos);
        super.m_6810_(state, level, pos, newState, $$4);
    }

    public static void dropContentsOnDestroy(BlockState $$0, BlockState $$1, Level $$2, BlockPos $$3) {
        BlockEntity $$4;
        if (!$$0.m_60713_($$1.m_60734_()) && ($$4 = $$2.m_7702_($$3)) instanceof Container) {
            Container $$5 = (Container)$$4;
            Containers.m_19002_((Level)$$2, (BlockPos)$$3, (Container)$$5);
            $$2.m_46717_($$3, $$0.m_60734_());
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos $$2, BlockState $$3, boolean $$4) {
        if (!$$3.m_60713_(state.m_60734_())) {
            this.checkPoweredState(level, $$2, state);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        this.checkPoweredState(level, pos, state);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !level.m_276867_(pos);
        if (flag != (Boolean)state.m_61143_((Property)ENABLED)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public void m_214162_(BlockState p_221253_, Level p_221254_, BlockPos p_221255_, RandomSource p_221256_) {
        boolean cooling = (Boolean)p_221253_.m_61143_((Property)COOLING);
        boolean heating = (Boolean)p_221253_.m_61143_((Property)HEATING);
        Direction direction = (Direction)p_221253_.m_61143_((Property)FACING);
        Direction.Axis direction$axis = direction.m_122434_();
        BlockPos blockpos = p_221255_.m_121945_(direction);
        BlockState blockstate = p_221254_.m_8055_(blockpos);
        if ((cooling || heating) && !ThermoregulatorBlock.m_49918_((VoxelShape)blockstate.m_60812_((BlockGetter)p_221254_, blockpos), (Direction)direction.m_122424_())) {
            double d0 = (double)p_221255_.m_123341_() + 0.5;
            double d1 = (double)p_221255_.m_123342_() + 0.5;
            double d2 = (double)p_221255_.m_123343_() + 0.5;
            double d4 = p_221256_.m_188500_() * 0.3 - p_221256_.m_188500_() * 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.55 : d4;
            double d6 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.55 : d4;
            double ymove = p_221256_.m_188500_() * 0.05 - p_221256_.m_188500_() * 0.05;
            double xmove = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.15 : ymove;
            double zmove = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.15 : ymove;
            SimpleParticleType particle = TANParticles.THERMOREGULATOR_NEUTRAL;
            if (cooling && !heating) {
                particle = TANParticles.THERMOREGULATOR_COOL;
            }
            if (!cooling && heating) {
                particle = TANParticles.THERMOREGULATOR_WARM;
            }
            p_221254_.m_7106_((ParticleOptions)particle, d0 + d5, d1 + d4, d2 + d6, xmove, ymove, zmove);
        }
    }
}

