/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block.entity;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import toughasnails.api.blockentity.TANBlockEntityTypes;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.block.ThermoregulatorBlock;
import toughasnails.container.ThermoregulatorContainer;
import toughasnails.init.ModTags;
import toughasnails.temperature.AreaFill;

public class ThermoregulatorBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    public static final int INFORM_PLAYER_RADIUS = 20;
    private static final int SPREAD_RADIUS = 16;
    public static final int CONSUMABLE_DURATION = 1600;
    public static final int SLOT_COOLING = 0;
    public static final int SLOT_HEATING = 1;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private int coolingTimeRemaining;
    private int heatingTimeRemaining;
    private int fillTimer = 0;
    private Set<BlockPos> filledBlocks = new HashSet<BlockPos>();
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return ThermoregulatorBlockEntity.this.coolingTimeRemaining;
                }
                case 1: {
                    return ThermoregulatorBlockEntity.this.heatingTimeRemaining;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ThermoregulatorBlockEntity.this.coolingTimeRemaining = value;
                    break;
                }
                case 1: {
                    ThermoregulatorBlockEntity.this.heatingTimeRemaining = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public ThermoregulatorBlockEntity(BlockPos pos, BlockState state) {
        super(TANBlockEntityTypes.THERMOREGULATOR, pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.coolingTimeRemaining = nbt.m_128451_("CoolingTimeRemaining");
        this.heatingTimeRemaining = nbt.m_128451_("HeatingTimeRemaining");
        this.fillTimer = nbt.m_128451_("FillTimer");
        ListTag list = nbt.m_128437_("FilledBlocks", 10);
        this.filledBlocks = list.stream().map(tag -> NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag))).collect(Collectors.toCollection(HashSet::new));
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("CoolingTimeRemaining", this.coolingTimeRemaining);
        nbt.m_128405_("HeatingTimeRemaining", this.heatingTimeRemaining);
        nbt.m_128405_("FillTimer", this.fillTimer);
        ListTag list = new ListTag();
        this.filledBlocks.stream().map(NbtUtils::m_129224_).forEach(arg_0 -> list.add(arg_0));
        nbt.m_128365_("FilledBlocks", (Tag)list);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, final ThermoregulatorBlockEntity blockEntity) {
        Item remainingItem;
        Item fuelItem;
        Object fuel;
        boolean previouslyCooling = blockEntity.isCooling();
        boolean previouslyHeating = blockEntity.isHeating();
        boolean changed = false;
        if (!((Boolean)state.m_61143_((Property)ThermoregulatorBlock.ENABLED)).booleanValue()) {
            blockEntity.filledBlocks.clear();
            if (((Boolean)state.m_61143_((Property)ThermoregulatorBlock.COOLING)).booleanValue() || ((Boolean)state.m_61143_((Property)ThermoregulatorBlock.HEATING)).booleanValue()) {
                state = (BlockState)((BlockState)state.m_61124_((Property)ThermoregulatorBlock.COOLING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ThermoregulatorBlock.HEATING, (Comparable)Boolean.valueOf(false));
                level.m_7731_(pos, state, 3);
                ThermoregulatorBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
            return;
        }
        if (blockEntity.isCooling()) {
            --blockEntity.coolingTimeRemaining;
        }
        if (blockEntity.isHeating()) {
            --blockEntity.heatingTimeRemaining;
        }
        if (!blockEntity.isCooling() && !(fuel = (ItemStack)blockEntity.items.get(0)).m_41619_()) {
            fuelItem = fuel.m_41720_();
            blockEntity.coolingTimeRemaining = 1600;
            changed = true;
            fuel.m_41774_(1);
            if (fuel.m_41619_()) {
                remainingItem = fuelItem.m_41469_();
                blockEntity.items.set(0, (Object)(remainingItem == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)remainingItem)));
            }
        }
        if (!blockEntity.isHeating() && !(fuel = (ItemStack)blockEntity.items.get(1)).m_41619_()) {
            fuelItem = fuel.m_41720_();
            blockEntity.heatingTimeRemaining = 1600;
            changed = true;
            fuel.m_41774_(1);
            if (fuel.m_41619_()) {
                remainingItem = fuelItem.m_41469_();
                blockEntity.items.set(1, (Object)(remainingItem == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)remainingItem)));
            }
        }
        if (((Boolean)state.m_61143_((Property)ThermoregulatorBlock.COOLING)).booleanValue() != blockEntity.isCooling()) {
            changed = true;
            state = (BlockState)state.m_61124_((Property)ThermoregulatorBlock.COOLING, (Comparable)Boolean.valueOf(blockEntity.isCooling()));
            level.m_7731_(pos, state, 3);
        }
        if (((Boolean)state.m_61143_((Property)ThermoregulatorBlock.HEATING)).booleanValue() != blockEntity.isHeating()) {
            changed = true;
            state = (BlockState)state.m_61124_((Property)ThermoregulatorBlock.HEATING, (Comparable)Boolean.valueOf(blockEntity.isHeating()));
            level.m_7731_(pos, state, 3);
        }
        if (!blockEntity.isHeating() && !blockEntity.isCooling()) {
            blockEntity.filledBlocks.clear();
        }
        if ((blockEntity.isCooling() || blockEntity.isHeating()) && blockEntity.fillTimer % 20 == 0) {
            for (ServerPlayer player : level.m_45976_(ServerPlayer.class, new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)pos.m_123341_(), (double)(pos.m_123342_() - 4), (double)pos.m_123343_()).m_82377_(20.0, 10.0, 20.0))) {
                ITemperature temperature = TemperatureHelper.getTemperatureData((Player)player);
                temperature.getNearbyThermoregulators().add(pos);
            }
            BlockPos fillStart = pos.m_121945_((Direction)state.m_61143_((Property)ThermoregulatorBlock.FACING));
            blockEntity.filledBlocks.clear();
            AreaFill.fill(level, fillStart, new AreaFill.PositionChecker(){

                @Override
                public void onSolid(Level level, AreaFill.FillPos pos) {
                }

                @Override
                public void onPassable(Level level, AreaFill.FillPos pos) {
                    blockEntity.filledBlocks.add(pos.pos());
                }

                @Override
                public boolean isPassable(Level level, AreaFill.FillPos pos) {
                    BlockState state = level.m_8055_(pos.pos());
                    return this.isConfined(level, pos.pos()) && (state.m_60795_() || state.m_204336_(ModTags.Blocks.PASSABLE_BLOCKS) || !this.isFlowBlocking(level, pos, state));
                }
            }, 16);
            changed = true;
        }
        ++blockEntity.fillTimer;
        if (changed) {
            ThermoregulatorBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            level.m_7260_(pos, state, state, 3);
        }
    }

    public Effect getEffectAtPos(BlockPos pos) {
        if (this.filledBlocks.contains(pos)) {
            return this.getEffect();
        }
        return Effect.NONE;
    }

    public ImmutableSet<BlockPos> getFilledBlocks() {
        return ImmutableSet.copyOf(this.filledBlocks);
    }

    public Effect getEffect() {
        boolean cooling = this.isCooling();
        boolean heating = this.isHeating();
        if (cooling && heating) {
            return Effect.NEUTRALIZING;
        }
        if (cooling) {
            return Effect.COOLING;
        }
        if (heating) {
            return Effect.HEATING;
        }
        return Effect.NONE;
    }

    public boolean isCooling() {
        return this.coolingTimeRemaining > 0;
    }

    public boolean isHeating() {
        return this.heatingTimeRemaining > 0;
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new ThermoregulatorContainer(id, player, (Container)this, this.dataAccess);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.toughasnails.thermoregulator");
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.UP) {
            return new int[]{0, 1};
        }
        BlockState state = this.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)ThermoregulatorBlock.FACING);
        if (facing.m_122427_() == direction) {
            return new int[]{0};
        }
        if (facing.m_122428_() == direction) {
            return new int[]{1};
        }
        return new int[0];
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 0) {
            return ThermoregulatorBlockEntity.isCoolingFuel(stack);
        }
        if (index == 1) {
            return ThermoregulatorBlockEntity.isHeatingFuel(stack);
        }
        return false;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack currentStack = (ItemStack)this.items.get(index);
        boolean sameItem = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)currentStack);
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (!sameItem) {
            this.m_6596_();
        }
    }

    public void m_6211_() {
        this.items.clear();
    }

    public static boolean isCoolingFuel(ItemStack stack) {
        return stack.m_204117_(ModTags.Items.THERMOREGULATOR_COOLING_FUEL);
    }

    public static boolean isHeatingFuel(ItemStack stack) {
        return stack.m_204117_(ModTags.Items.THERMOREGULATOR_HEATING_FUEL);
    }

    public static enum Effect {
        COOLING,
        HEATING,
        NEUTRALIZING,
        NONE;

    }
}

