/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import glitchcore.event.client.RegisterColorsEvent;
import glitchcore.event.client.RegisterParticleSpritesEvent;
import glitchcore.util.RenderHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import toughasnails.api.block.TANBlocks;
import toughasnails.api.item.TANItems;
import toughasnails.api.particle.TANParticles;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.client.particle.ThermoregulatorParticle;
import toughasnails.item.DyeableWoolItem;
import toughasnails.item.LeafArmorItem;
import toughasnails.temperature.TemperatureHelperImpl;

public class ModClient {
    static void registerItemProperties() {
        ItemProperties.register((Item)TANItems.THERMOMETER, (ResourceLocation)new ResourceLocation("toughasnails", "temperature"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            final Map<Integer, Delta> deltas = new HashMap<Integer, Delta>();

            public float m_142187_(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
                LivingEntity holder;
                Object object = holder = entity != null ? entity : stack.m_41609_();
                if (holder == null) {
                    return 0.5f;
                }
                if (level == null && holder.m_9236_() instanceof ClientLevel) {
                    level = (ClientLevel)holder.m_9236_();
                }
                if (level == null) {
                    return 0.5f;
                }
                Delta delta = this.deltas.computeIfAbsent(holder.m_19879_(), k -> new Delta());
                delta.update(level, 1.getTemperatureForThermometer((Level)level, (Entity)holder));
                return delta.getValue();
            }

            private static TemperatureLevel getTemperatureForThermometer(Level level, Entity holder) {
                TemperatureLevel temperatureLevel = TemperatureHelper.getTemperatureAtPos(level, holder.m_20183_());
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                Set<BlockPos> nearbyThermoregulators = TemperatureHelper.getTemperatureData((Player)player).getNearbyThermoregulators();
                return TemperatureHelperImpl.modifyTemperatureByThermoregulators(level, nearbyThermoregulators, holder.m_20183_(), temperatureLevel);
            }

            private static class Delta {
                private long lastUpdateTick;
                private double currentValue;
                private double rota;

                private Delta() {
                }

                private void update(ClientLevel level, TemperatureLevel temperatureLevel) {
                    if (level.m_46467_() == this.lastUpdateTick) {
                        return;
                    }
                    this.lastUpdateTick = level.m_46467_();
                    double targetValue = (double)temperatureLevel.ordinal() * 0.25;
                    double delta = targetValue - this.currentValue;
                    this.rota += delta * 0.1;
                    this.rota *= 0.87;
                    this.currentValue = Mth.m_14008_((double)(this.currentValue + this.rota), (double)0.0, (double)1.0);
                }

                public float getValue() {
                    return (float)((double)Math.round(this.currentValue * 20.0) / 20.0);
                }
            }
        });
    }

    public static void registerItemColors(RegisterColorsEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : ((DyeableWoolItem)stack.m_41720_()).m_41121_(stack), (Object[])new ItemLike[]{TANItems.WOOL_HELMET, TANItems.WOOL_CHESTPLATE, TANItems.WOOL_LEGGINGS, TANItems.WOOL_BOOTS});
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : ((LeafArmorItem)stack.m_41720_()).m_41121_(stack), (Object[])new ItemLike[]{TANItems.LEAF_HELMET, TANItems.LEAF_CHESTPLATE, TANItems.LEAF_LEGGINGS, TANItems.LEAF_BOOTS});
    }

    public static void registerBlockColors(RegisterColorsEvent.Block event) {
        event.register((state, world, pos, tintIndex) -> 4709119, (Object[])new Block[]{TANBlocks.RAIN_COLLECTOR});
        event.register((state, world, pos, tintIndex) -> 4159204, (Object[])new Block[]{TANBlocks.WATER_PURIFIER});
    }

    public static void registerParticleSprites(RegisterParticleSpritesEvent event) {
        event.registerSpriteSet((ParticleType)TANParticles.THERMOREGULATOR_COOL, ThermoregulatorParticle.Provider::new);
        event.registerSpriteSet((ParticleType)TANParticles.THERMOREGULATOR_WARM, ThermoregulatorParticle.Provider::new);
        event.registerSpriteSet((ParticleType)TANParticles.THERMOREGULATOR_NEUTRAL, ThermoregulatorParticle.Provider::new);
    }

    public static void setupRenderTypes() {
        RenderType transparentRenderType = RenderType.m_110457_();
        RenderType cutoutRenderType = RenderType.m_110463_();
        RenderType translucentRenderType = RenderType.m_110466_();
        RenderHelper.setRenderType((Block)TANBlocks.RAIN_COLLECTOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)TANBlocks.WATER_PURIFIER, (RenderType)cutoutRenderType);
    }
}

