/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import glitchcore.event.entity.LivingEntityUseItemEvent;
import glitchcore.event.player.PlayerEvent;
import glitchcore.network.CustomPacket;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import toughasnails.api.damagesource.TANDamageTypes;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.init.ModConfig;
import toughasnails.init.ModPackets;
import toughasnails.init.ModTags;
import toughasnails.network.UpdateTemperaturePacket;
import toughasnails.temperature.BuiltInTemperatureModifier;
import toughasnails.temperature.TemperatureData;

public class TemperatureHandler {
    private static final UUID SPEED_MODIFIER_HYPERTHERMIA_UUID = UUID.fromString("30b6ca4e-c6df-4532-80db-1d024765b56b");

    public static void onPlayerTick(Player player) {
        if (!ModConfig.temperature.enableTemperature || player.m_9236_().m_5776_()) {
            return;
        }
        Level level = player.m_9236_();
        ITemperature data = TemperatureHelper.getTemperatureData(player);
        data.getNearbyThermoregulators().removeIf(pos -> level.m_7702_(pos) == null || player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) > 1024.0);
        data.setChangeDelayTicks(Math.max(0, data.getChangeDelayTicks() - 1));
        data.setDryTicks(data.getDryTicks() + 1);
        if (!player.m_21023_(TANEffects.CLIMATE_CLEMENCY)) {
            int changeDelay = ModConfig.temperature.temperatureChangeDelay;
            TemperatureLevel currentTargetLevel = data.getTargetLevel();
            TemperatureLevel newTargetLevel = TemperatureHelper.getTemperatureAtPos(player.m_9236_(), player.m_20183_());
            for (BuiltInTemperatureModifier modifier : BuiltInTemperatureModifier.getTemperatureModifierOrder()) {
                Tuple<TemperatureLevel, Integer> output = modifier.apply(player, newTargetLevel, changeDelay);
                newTargetLevel = (TemperatureLevel)((Object)output.m_14418_());
                changeDelay = (Integer)output.m_14419_();
            }
            if (newTargetLevel != currentTargetLevel) {
                data.setTargetLevel(newTargetLevel);
                if ((data.getLevel() == TemperatureLevel.ICY || data.getLevel() == TemperatureLevel.HOT) && newTargetLevel != TemperatureLevel.ICY && newTargetLevel != TemperatureLevel.HOT) {
                    changeDelay = Math.min(changeDelay, ModConfig.temperature.extremityReboundTemperatureChangeDelay);
                }
                data.setChangeDelayTicks(changeDelay);
            }
            if (data.getChangeDelayTicks() == 0 && currentTargetLevel != data.getLevel()) {
                data.setLevel(data.getLevel().increment(Mth.m_14205_((double)(data.getTargetLevel().ordinal() - data.getLevel().ordinal()))));
                data.setChangeDelayTicks(changeDelay);
            }
        } else {
            data.setLevel(TemperatureLevel.NEUTRAL);
        }
        data.setExtremityDelayTicks(Math.max(0, data.getExtremityDelayTicks() - 1));
        if (data.getLastLevel() != data.getLevel() && (data.getLevel() == TemperatureLevel.ICY || data.getLevel() == TemperatureLevel.HOT)) {
            data.setExtremityDelayTicks(ModConfig.temperature.extremityDamageDelay);
        }
        int hyperthermicTicks = data.getHyperthermiaTicks();
        int ticksToHyperthermia = TemperatureHelper.getTicksRequiredForHyperthermia();
        if (!player.m_7500_() && !player.m_5833_()) {
            if (!player.m_21023_(MobEffects.f_19607_) && data.getLevel() == TemperatureLevel.HOT && data.getExtremityDelayTicks() == 0) {
                data.setHyperthermiaTicks(Math.min(ticksToHyperthermia, hyperthermicTicks + 1));
            } else {
                data.setHyperthermiaTicks(Math.max(0, hyperthermicTicks - 2));
            }
        } else if (data.getHyperthermiaTicks() > 0) {
            data.setHyperthermiaTicks(Math.max(0, hyperthermicTicks - 2));
        }
        TemperatureHandler.removeHeatExhaustion(player);
        TemperatureHandler.tryAddHeatExhaustion(player);
        if (player.f_19797_ % 40 == 0 && TemperatureHelper.isFullyHyperthermic(player)) {
            player.m_6469_(player.m_269291_().m_269079_(TANDamageTypes.HYPERTHERMIA), 1.0f);
        }
    }

    public static void onChangeDimension(PlayerEvent.ChangeDimension event) {
        ITemperature temperature = TemperatureHelper.getTemperatureData(event.getPlayer());
        temperature.setLastLevel(TemperatureData.DEFAULT_LEVEL);
        temperature.setLastHyperthermiaTicks(0);
        temperature.setLastNearbyThermoregulators(new HashSet<BlockPos>());
    }

    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!ModConfig.temperature.enableTemperature || !(event.getEntity() instanceof Player) || event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack item = event.getItem();
        if (item.m_204117_(ModTags.Items.COOLING_CONSUMED_ITEMS)) {
            player.m_7292_(new MobEffectInstance(TANEffects.INTERNAL_CHILL, ModConfig.temperature.consumableEffectDuration, 0, false, false, true));
        }
        if (item.m_204117_(ModTags.Items.HEATING_CONSUMED_ITEMS)) {
            player.m_7292_(new MobEffectInstance(TANEffects.INTERNAL_WARMTH, ModConfig.temperature.consumableEffectDuration, 0, false, false, true));
        }
    }

    public static void syncTemperature(ServerPlayer player) {
        ITemperature temperature = TemperatureHelper.getTemperatureData((Player)player);
        ModPackets.HANDLER.sendToPlayer((CustomPacket)new UpdateTemperaturePacket(temperature.getLevel(), temperature.getHyperthermiaTicks(), temperature.getNearbyThermoregulators()), player);
        temperature.setLastLevel(temperature.getLevel());
        temperature.setLastHyperthermiaTicks(temperature.getHyperthermiaTicks());
        temperature.setNearbyThermoregulators(temperature.getNearbyThermoregulators());
    }

    private static void removeHeatExhaustion(Player player) {
        AttributeInstance attribute = player.m_21051_(Attributes.f_22279_);
        if (attribute != null && attribute.m_22111_(SPEED_MODIFIER_HYPERTHERMIA_UUID) != null) {
            attribute.m_22120_(SPEED_MODIFIER_HYPERTHERMIA_UUID);
        }
    }

    protected static void tryAddHeatExhaustion(Player player) {
        int ticks;
        if (!player.m_9236_().m_8055_(player.m_20097_()).m_60795_() && (ticks = TemperatureHelper.getTicksHyperthermic(player)) > 0) {
            AttributeInstance attributeinstance = player.m_21051_(Attributes.f_22279_);
            if (attributeinstance == null) {
                return;
            }
            float f = 0.015f * TemperatureHelper.getPercentHyperthermic(player);
            attributeinstance.m_22118_(new AttributeModifier(SPEED_MODIFIER_HYPERTHERMIA_UUID, "Hyperthermia slow", (double)f, AttributeModifier.Operation.ADDITION));
        }
    }
}

