/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InventoryScannerFieldBlock
extends OwnableBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty HORIZONTAL = BooleanProperty.m_61465_((String)"horizontal");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_EW = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_NS = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape HORIZONTAL_SHAPE = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public InventoryScannerFieldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HORIZONTAL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        EntityCollisionContext ctx;
        if (!(collisionContext instanceof EntityCollisionContext) || (ctx = (EntityCollisionContext)collisionContext).m_193113_() == null) {
            return Shapes.m_83040_();
        }
        Entity entity = ctx.m_193113_();
        Level level = entity.m_20193_();
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos);
        if (connectedScanner != null && connectedScanner.doesFieldSolidify()) {
            Player player;
            if (entity instanceof Player && !connectedScanner.isConsideredInvisible((LivingEntity)(player = (Player)entity))) {
                if (connectedScanner.isAllowed(entity)) {
                    return Shapes.m_83040_();
                }
                List<ItemStack> prohibitedItems = connectedScanner.getAllProhibitedItems();
                if (!prohibitedItems.isEmpty() && InventoryScannerFieldBlock.checkInventory(player, connectedScanner, prohibitedItems, false)) {
                    return this.m_5940_(state, (BlockGetter)level, pos, (CollisionContext)ctx);
                }
            } else if (entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                List<ItemStack> prohibitedItems = connectedScanner.getAllProhibitedItems();
                if (!prohibitedItems.isEmpty() && InventoryScannerFieldBlock.checkItemEntity(item, connectedScanner, prohibitedItems, false)) {
                    return this.m_5940_(state, (BlockGetter)level, pos, (CollisionContext)ctx);
                }
            }
        }
        return Shapes.m_83040_();
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        Player player;
        if (!this.m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82750_((Entity)entity)).m_83215_().m_82338_(pos).m_82381_(entity.m_20191_())) {
            return;
        }
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos);
        if (connectedScanner == null || connectedScanner.doesFieldSolidify()) {
            return;
        }
        if (entity instanceof Player && !connectedScanner.isConsideredInvisible((LivingEntity)(player = (Player)entity))) {
            if (connectedScanner.isAllowed(entity)) {
                return;
            }
            List<ItemStack> prohibitedItems = connectedScanner.getAllProhibitedItems();
            if (!prohibitedItems.isEmpty()) {
                InventoryScannerFieldBlock.checkInventory(player, connectedScanner, prohibitedItems, true);
            }
        } else if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            List<ItemStack> prohibitedItems = connectedScanner.getAllProhibitedItems();
            if (!prohibitedItems.isEmpty()) {
                InventoryScannerFieldBlock.checkItemEntity(item, connectedScanner, prohibitedItems, true);
            }
        }
    }

    public static boolean checkInventory(Player player, InventoryScannerBlockEntity be, List<ItemStack> prohibitedItems, boolean allowInteraction) {
        boolean hasRedstoneModule;
        boolean hasSmartModule = be.isModuleEnabled(ModuleType.SMART);
        boolean hasStorageModule = allowInteraction && be.isModuleEnabled(ModuleType.STORAGE);
        boolean bl = hasRedstoneModule = allowInteraction && be.isModuleEnabled(ModuleType.REDSTONE);
        if (!hasRedstoneModule && !hasStorageModule && allowInteraction || be.isOwnedBy((Entity)player) && be.ignoresOwner()) {
            return false;
        }
        return InventoryScannerFieldBlock.loopInventory((NonNullList<ItemStack>)player.m_150109_().f_35974_, prohibitedItems, be, hasSmartModule, hasStorageModule, hasRedstoneModule) || InventoryScannerFieldBlock.loopInventory((NonNullList<ItemStack>)player.m_150109_().f_35975_, prohibitedItems, be, hasSmartModule, hasStorageModule, hasRedstoneModule) || InventoryScannerFieldBlock.loopInventory((NonNullList<ItemStack>)player.m_150109_().f_35976_, prohibitedItems, be, hasSmartModule, hasStorageModule, hasRedstoneModule);
    }

    private static boolean loopInventory(NonNullList<ItemStack> inventory, List<ItemStack> prohibitedItems, InventoryScannerBlockEntity be, boolean hasSmartModule, boolean hasStorageModule, boolean hasRedstoneModule) {
        boolean itemFound = false;
        block0: for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stackToCheck = (ItemStack)inventory.get(i);
            if (stackToCheck.m_41619_()) continue;
            for (ItemStack prohibitedItem : prohibitedItems) {
                if (InventoryScannerFieldBlock.areItemsEqual(stackToCheck, prohibitedItem, hasSmartModule)) {
                    if (hasStorageModule) {
                        ItemStack remainder = be.addItemToStorage((ItemStack)inventory.get(i));
                        if (!remainder.m_41619_()) {
                            Block.m_49840_((Level)be.m_58904_(), (BlockPos)be.m_58899_(), (ItemStack)remainder.m_41777_());
                        }
                        inventory.set(i, (Object)ItemStack.f_41583_);
                    }
                    if (hasRedstoneModule) {
                        InventoryScannerFieldBlock.updateInventoryScannerPower(be);
                    }
                    itemFound = true;
                    continue block0;
                }
                if (!InventoryScannerFieldBlock.checkForContainer(stackToCheck, prohibitedItem, be, hasSmartModule, hasStorageModule, hasRedstoneModule) && !InventoryScannerFieldBlock.checkForBundle(stackToCheck, prohibitedItem, be, hasSmartModule, hasStorageModule, hasRedstoneModule)) continue;
                itemFound = true;
                continue block0;
            }
        }
        return itemFound;
    }

    public static boolean checkItemEntity(ItemEntity entity, InventoryScannerBlockEntity be, List<ItemStack> prohibitedItems, boolean allowInteraction) {
        boolean hasRedstoneModule;
        boolean hasSmartModule = be.isModuleEnabled(ModuleType.SMART);
        boolean hasStorageModule = allowInteraction && be.isModuleEnabled(ModuleType.STORAGE);
        boolean bl = hasRedstoneModule = allowInteraction && be.isModuleEnabled(ModuleType.REDSTONE);
        if (!hasRedstoneModule && !hasStorageModule && allowInteraction) {
            return false;
        }
        for (ItemStack prohibitedItem : prohibitedItems) {
            if (InventoryScannerFieldBlock.areItemsEqual(entity.m_32055_(), prohibitedItem, hasSmartModule)) {
                if (hasStorageModule) {
                    ItemStack remainder = be.addItemToStorage(entity.m_32055_());
                    if (!remainder.m_41619_()) {
                        Block.m_49840_((Level)be.m_58904_(), (BlockPos)be.m_58899_(), (ItemStack)remainder.m_41777_());
                    }
                    entity.m_146870_();
                }
                if (hasRedstoneModule) {
                    InventoryScannerFieldBlock.updateInventoryScannerPower(be);
                }
                return true;
            }
            if (!InventoryScannerFieldBlock.checkForContainer(entity.m_32055_(), prohibitedItem, be, hasSmartModule, hasStorageModule, hasRedstoneModule) && !InventoryScannerFieldBlock.checkForBundle(entity.m_32055_(), prohibitedItem, be, hasSmartModule, hasStorageModule, hasRedstoneModule)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkForContainer(ItemStack item, ItemStack stackToCheck, InventoryScannerBlockEntity be, boolean hasSmartModule, boolean hasStorageModule, boolean hasRedstoneModule) {
        if (item != null && !item.m_41619_() && item.m_41783_() != null) {
            ListTag list = item.m_41783_().m_128469_("BlockEntityTag").m_128437_("Items", 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemInChest = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                if (!InventoryScannerFieldBlock.areItemsEqual(itemInChest, stackToCheck, hasSmartModule)) continue;
                if (hasStorageModule) {
                    ItemStack remainder = be.addItemToStorage(itemInChest);
                    if (!remainder.m_41619_()) {
                        Block.m_49840_((Level)be.m_58904_(), (BlockPos)be.m_58899_(), (ItemStack)remainder.m_41777_());
                    }
                    list.remove(i);
                }
                if (hasRedstoneModule) {
                    InventoryScannerFieldBlock.updateInventoryScannerPower(be);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean checkForBundle(ItemStack item, ItemStack stackToCheck, InventoryScannerBlockEntity be, boolean hasSmartModule, boolean hasStorageModule, boolean hasRedstoneModule) {
        if (item != null && item.m_41720_() instanceof BundleItem) {
            List items = BundleItem.m_150782_((ItemStack)item).collect(Collectors.toList());
            for (int i = 0; i < items.size(); ++i) {
                ItemStack itemInChest = (ItemStack)items.get(i);
                if (!InventoryScannerFieldBlock.areItemsEqual(itemInChest, stackToCheck, hasSmartModule)) continue;
                if (hasStorageModule) {
                    ItemStack remainder = be.addItemToStorage(itemInChest);
                    if (!remainder.m_41619_()) {
                        Block.m_49840_((Level)be.m_58904_(), (BlockPos)be.m_58899_(), (ItemStack)remainder.m_41777_());
                    }
                    items.remove(i);
                    item.m_41783_().m_128365_("Items", (Tag)items.stream().map(stack -> stack.m_41739_(new CompoundTag())).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll));
                }
                if (hasRedstoneModule) {
                    InventoryScannerFieldBlock.updateInventoryScannerPower(be);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean areItemsEqual(ItemStack firstItemStack, ItemStack secondItemStack, boolean hasSmartModule) {
        return hasSmartModule && InventoryScannerFieldBlock.areItemStacksEqual(firstItemStack, secondItemStack) && ItemStack.m_150942_((ItemStack)firstItemStack, (ItemStack)secondItemStack) || !hasSmartModule && firstItemStack.m_41720_() == secondItemStack.m_41720_();
    }

    private static void updateInventoryScannerPower(InventoryScannerBlockEntity be) {
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(be.m_58904_(), be.m_58899_());
        if (connectedScanner == null) {
            return;
        }
        be.togglePowerOutput();
        connectedScanner.togglePowerOutput();
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        ItemStack s1 = stack1.m_41777_();
        ItemStack s2 = stack2.m_41777_();
        s1.m_41764_(1);
        s2.m_41764_(1);
        return ItemStack.m_41728_((ItemStack)s1, (ItemStack)s2);
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            BlockUtils.removeInSequence((direction, stateToCheck) -> {
                if (stateToCheck.m_60734_() != SCContent.INVENTORY_SCANNER_FIELD.get()) {
                    return false;
                }
                Direction stateToCheckFacing = (Direction)stateToCheck.m_61143_((Property)FACING);
                return stateToCheckFacing == direction || stateToCheckFacing == direction.m_122424_();
            }, level, pos, facing, facing.m_122424_());
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (((Boolean)state.m_61143_((Property)HORIZONTAL)).booleanValue()) {
            return HORIZONTAL_SHAPE;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing == Direction.EAST || facing == Direction.WEST) {
            return SHAPE_EW;
        }
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            return SHAPE_NS;
        }
        return Shapes.m_83144_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HORIZONTAL, WATERLOGGED});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ItemStack.f_41583_;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity((BlockEntityType)SCContent.ABSTRACT_BLOCK_ENTITY.get(), pos, state);
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        if ((side == Direction.UP || side == Direction.DOWN) && state.m_60734_() == adjacentBlockState.m_60734_()) {
            return true;
        }
        return super.m_6104_(state, adjacentBlockState, side);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

