/*
 * Decompiled with CFR 0.152.
 */
package sguest.jeimultiblocks.jei;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sguest.jeimultiblocks.ContentHelper;
import sguest.jeimultiblocks.JeiMultiblocksEventHandler;
import sguest.jeimultiblocks.jei.MultiblockRecipeCategory;

@JeiPlugin
public class JeiModPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jeimultiblocks", "plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(ContentHelper.getHammer(), new RecipeType[]{MultiblockRecipeCategory.recipeType});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new MultiblockRecipeCategory(guiHelper)});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JeiMultiblocksEventHandler.registerCallback(() -> {
            jeiRuntime.getRecipeManager().addRecipes(MultiblockRecipeCategory.recipeType, this.getMultiblockRecipes());
            return true;
        });
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, this.getMultiblockItems());
    }

    private List<MultiblockHandler.IMultiblock> getMultiblockRecipes() {
        return MultiblockHandler.getMultiblocks().stream().filter(item -> item instanceof TemplateMultiblock).collect(Collectors.toList());
    }

    private List<ItemStack> getMultiblockItems() {
        return MultiblockHandler.getMultiblocks().stream().filter(item -> item instanceof TemplateMultiblock).map(item -> new ItemStack((ItemLike)item.getBlock())).collect(Collectors.toList());
    }
}

