/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import de.cheaterpaul.fallingleaves.init.ClientMod;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LeafSettingLoader
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    private Map<ResourceLocation, LeafSettingsEntry> treeLeaveSizeValues = new HashMap<ResourceLocation, LeafSettingsEntry>();

    public LeafSettingLoader() {
        super(GSON, "fallingleaves/settings");
    }

    protected void apply(Map<ResourceLocation, JsonElement> values, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        HashMap<ResourceLocation, LeafSettingsEntry> map = new HashMap<ResourceLocation, LeafSettingsEntry>();
        values.forEach((id, json) -> {
            try {
                JsonObject object = GsonHelper.m_13918_((JsonElement)json, (String)"leafsettings");
                double spawn_rate = object.has("spawnrate") ? object.get("spawnrate").getAsDouble() : 1.0;
                ResourceLocation leafType = object.has("leaf_type") ? new ResourceLocation(object.get("leaf_type").getAsString()) : id;
                boolean considerAsConifer = false;
                if (object.has("isConifer") && object.get("isConifer").getAsBoolean()) {
                    leafType = ClientMod.CONIFER;
                    considerAsConifer = true;
                }
                considerAsConifer = object.has("consider_as_conifer") ? object.get("consider_as_conifer").getAsBoolean() : considerAsConifer;
                map.put((ResourceLocation)id, new LeafSettingsEntry((ResourceLocation)id, spawn_rate, leafType, considerAsConifer));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOGGER.error("Parsing error loading leaf settings {}: {}", json, (Object)e.getMessage());
            }
        });
        this.treeLeaveSizeValues = map;
    }

    @Nullable
    public LeafSettingsEntry getLeafSetting(ResourceLocation loc) {
        return this.treeLeaveSizeValues.get(loc);
    }

    @Nonnull
    public Collection<LeafSettingsEntry> getALlSettings() {
        return this.treeLeaveSizeValues.values();
    }
}

