/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.data.KeyboardData;
import net.montoyo.wd.entity.AbstractPeripheralBlockEntity;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.entity.ScreenData;
import net.montoyo.wd.registry.TileRegistry;
import net.montoyo.wd.utilities.serialization.Util;

public class KeyboardBlockEntity
extends AbstractPeripheralBlockEntity {
    private static final String RANDOM_CHARS = "AZERTYUIOPQSDFGHJKLMWXCVBNazertyuiopqsdfghjklmwxcvbn0123456789";

    public KeyboardBlockEntity(BlockPos arg2, BlockState arg3) {
        super((BlockEntityType)TileRegistry.KEYBOARD.get(), arg2, arg3);
    }

    @Override
    public InteractionResult onRightClick(Player player, InteractionHand hand) {
        if (this.f_58857_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!this.isScreenChunkLoaded()) {
            Util.toast(player, "chunkUnloaded", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        ScreenBlockEntity tes = this.getConnectedScreen();
        if (tes == null) {
            Util.toast(player, "notLinked", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        ScreenData scr = tes.getScreen(this.screenSide);
        if ((scr.rightsFor(player) & 2) == 0) {
            Util.toast(player, "restrictions", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        new KeyboardData(tes, this.screenSide, this.m_58899_()).sendTo((ServerPlayer)player);
        return InteractionResult.SUCCESS;
    }

    public void simulateCat(Entity ent) {
        if (!this.isScreenChunkLoaded()) {
            return;
        }
        ScreenBlockEntity tes = this.getConnectedScreen();
        if (tes != null) {
            boolean ok;
            ScreenData scr = tes.getScreen(this.screenSide);
            if (ent instanceof Player) {
                ok = (scr.rightsFor((Player)ent) & 2) != 0;
            } else {
                boolean bl = ok = (scr.otherRights & 2) != 0;
            }
            if (ok) {
                char rnd = RANDOM_CHARS.charAt((int)(Math.random() * (double)RANDOM_CHARS.length()));
                tes.type(this.screenSide, "t" + rnd, this.m_58899_());
                Player owner = this.f_58857_.m_46003_(scr.owner.uuid);
                if (owner instanceof ServerPlayer && ent instanceof Ocelot) {
                    WebDisplays.INSTANCE.criterionKeyboardCat.trigger(((ServerPlayer)owner).m_8960_());
                }
            }
        }
    }
}

