/*
 * Decompiled with CFR 0.152.
 */
package wily.mozombieswave.entity;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import wily.mozombieswave.entity.Survivor;
import wily.mozombieswave.entity.ZombieNotch;

public class ZombieCreeper
extends Creeper {
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.m_135353_(ZombieCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = p_213697_0_ -> p_213697_0_ == Difficulty.HARD;
    private final BreakDoorGoal breakDoorGoal = new BreakDoorGoal((Mob)this, DOOR_BREAKING_PREDICATE);
    public static final int ID = 5;
    private UUID conversionStarter;
    public static final String name = "zombie_creeper";
    private int creeperConversionTime;
    private boolean canBreakDoors;

    public ZombieCreeper(EntityType<ZombieCreeper> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CONVERTING_ID, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new AttackTurtleEggGoal((PathfinderMob)this, 1.0, 3));
        super.m_8099_();
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, this::canBreakDoors));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{ZombifiedPiglin.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombieNotch.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Survivor.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean p_146070_1_) {
        if (GoalUtils.m_26894_((Mob)this)) {
            if (this.canBreakDoors != p_146070_1_) {
                this.canBreakDoors = p_146070_1_;
                ((GroundPathNavigation)this.m_21573_()).m_26477_(p_146070_1_);
                if (p_146070_1_) {
                    this.f_21345_.m_25352_(1, (Goal)this.breakDoorGoal);
                } else {
                    this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return SoundEvents.f_12646_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12045_;
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        super.m_7380_(p_213281_1_);
        p_213281_1_.m_128379_("CanBreakDoors", this.canBreakDoors());
        p_213281_1_.m_128405_("ConversionTime", this.isConverting() ? this.creeperConversionTime : -1);
        if (this.conversionStarter != null) {
            p_213281_1_.m_128362_("ConversionPlayer", this.conversionStarter);
        }
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        super.m_7378_(p_70037_1_);
        this.setCanBreakDoors(p_70037_1_.m_128471_("CanBreakDoors"));
        if (p_70037_1_.m_128425_("ConversionTime", 99) && p_70037_1_.m_128451_("ConversionTime") > -1) {
            this.startConverting(p_70037_1_.m_128403_("ConversionPlayer") ? p_70037_1_.m_128342_("ConversionPlayer") : null, p_70037_1_.m_128451_("ConversionTime"));
        }
    }

    public void m_8107_() {
        boolean flag = this.m_21527_();
        if (flag) {
            ItemStack itemstack = this.m_6844_(EquipmentSlot.HEAD);
            if (!itemstack.m_41619_()) {
                if (itemstack.m_41763_()) {
                    itemstack.m_41721_(itemstack.m_41773_() + this.f_19796_.m_188503_(2));
                    if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                        this.m_21166_(EquipmentSlot.HEAD);
                        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.m_20254_(8);
            }
        }
        super.m_8107_();
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.isConverting()) {
            int i = this.getConversionProgress();
            this.creeperConversionTime -= i;
            if (this.creeperConversionTime <= 0) {
                this.finishConversion((ServerLevel)this.m_9236_());
            }
        }
        super.m_8119_();
    }

    public boolean isConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_CONVERTING_ID);
    }

    public InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        if (itemstack.m_41720_() == Items.f_42436_) {
            if (this.m_21023_(MobEffects.f_19613_)) {
                if (!p_230254_1_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (!this.m_9236_().f_46443_) {
                    this.startConverting(p_230254_1_.m_20148_(), this.f_19796_.m_188503_(2401) + 3600);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    private int getConversionProgress() {
        int i = 1;
        if (this.f_19796_.m_188501_() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
            for (int k = (int)this.m_20185_() - 4; k < (int)this.m_20185_() + 4 && j < 14; ++k) {
                for (int l = (int)this.m_20186_() - 4; l < (int)this.m_20186_() + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.m_20189_() - 4; i1 < (int)this.m_20189_() + 4 && j < 14; ++i1) {
                        Block block = this.m_9236_().m_8055_((BlockPos)blockpos$mutable.m_122178_(k, l, i1)).m_60734_();
                        if (block != Blocks.f_50183_ && !(block instanceof BedBlock)) continue;
                        if (this.f_19796_.m_188501_() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    private void startConverting(@Nullable UUID p_191991_1_, int p_191991_2_) {
        this.conversionStarter = p_191991_1_;
        this.creeperConversionTime = p_191991_2_;
        this.m_20088_().m_135381_(DATA_CONVERTING_ID, (Object)true);
        this.m_21195_(MobEffects.f_19613_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, p_191991_2_, Math.min(this.m_9236_().m_46791_().m_19028_() - 1, 0)));
        this.m_9236_().m_7605_((Entity)this, (byte)16);
    }

    private void finishConversion(ServerLevel p_213791_1_) {
        Creeper creeperEntity = (Creeper)this.m_21406_(EntityType.f_20558_, false);
        creeperEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
        if (!this.m_20067_()) {
            p_213791_1_.m_5898_(null, 1027, this.m_20183_(), 0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 45.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22284_, 2.0).m_22266_(Attributes.f_22287_).m_22268_(Attributes.f_22276_, 25.0);
    }

    class AttackTurtleEggGoal
    extends RemoveBlockGoal {
        AttackTurtleEggGoal(PathfinderMob p_i50465_2_, double p_i50465_3_, int p_i50465_5_) {
            super(Blocks.f_50578_, p_i50465_2_, p_i50465_3_, p_i50465_5_);
        }

        public void playDestroyProgressSound(Level p_203114_1_, BlockPos p_203114_2_) {
            p_203114_1_.m_5594_((Player)null, p_203114_2_, SoundEvents.f_12604_, SoundSource.HOSTILE, 0.5f, 0.9f + ZombieCreeper.this.f_19796_.m_188501_() * 0.2f);
        }

        public void m_5777_(Level p_203116_1_, BlockPos p_203116_2_) {
            p_203116_1_.m_5594_((Player)null, p_203116_2_, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + p_203116_1_.f_46441_.m_188501_() * 0.2f);
        }

        public double m_8052_() {
            return 1.14;
        }
    }

    public static class CreeperRenderer
    extends net.minecraft.client.renderer.entity.CreeperRenderer {
        public CreeperRenderer(EntityRendererProvider.Context p_i50974_1_) {
            super(p_i50974_1_);
        }

        public ResourceLocation m_5478_(Creeper entity) {
            return new ResourceLocation("mozombies_wave", "textures/entity/zombie_creeper.png");
        }
    }
}

