/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal;

import com.mojang.brigadier.CommandDispatcher;
import guideme.PageAnchor;
import guideme.internal.GuideMEClient;
import guideme.internal.GuideMEProxy;
import guideme.internal.GuideMEServerProxy;
import guideme.internal.command.GuideCommand;
import guideme.internal.command.GuideIdArgument;
import guideme.internal.command.PageAnchorArgument;
import guideme.internal.item.GuideItem;
import guideme.internal.network.OpenGuideRequest;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;

@Mod(value="guideme")
public class GuideME {
    static GuideMEProxy PROXY = new GuideMEServerProxy();
    public static final String MOD_ID = "guideme";
    private static final DeferredRegister<Item> DR_ITEMS = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"guideme");
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> DR_ARGUMENT_TYPE_INFOS = DeferredRegister.create((ResourceKey)Registries.f_256982_, (String)"guideme");
    public static final Supplier<GuideItem> GUIDE_ITEM = DR_ITEMS.register("guide", () -> new GuideItem(GuideItem.PROPERTIES));
    private final SimpleChannel networkChannel;
    private static GuideME INSTANCE;

    public GuideME() {
        ModLoadingContext context = ModLoadingContext.get();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        INSTANCE = this;
        DR_ARGUMENT_TYPE_INFOS.register("guide_id", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(GuideIdArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(GuideIdArgument::argument)));
        DR_ARGUMENT_TYPE_INFOS.register("page_anchor", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(PageAnchorArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(PageAnchorArgument::argument)));
        DR_ARGUMENT_TYPE_INFOS.register(modBus);
        DR_ITEMS.register(modBus);
        this.networkChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)GuideME.makeId("channel"), () -> "1", s -> true, s -> true);
        this.networkChannel.registerMessage(0, OpenGuideRequest.class, OpenGuideRequest::write, OpenGuideRequest::read, this::handlePacket);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        if (FMLLoader.getDist().isClient()) {
            new GuideMEClient(context, modBus);
        }
    }

    private void registerCommands(RegisterCommandsEvent event) {
        GuideCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void handlePacket(OpenGuideRequest packet, Supplier<NetworkEvent.Context> contextSource) {
        NetworkEvent.Context ctx = contextSource.get();
        ctx.setPacketHandled(true);
        ctx.enqueueWork(() -> {
            Player player = Objects.requireNonNullElse(ctx.getSender(), GuideMEProxy.instance().getLocalPlayer());
            PageAnchor anchor = packet.pageAnchor().orElse(null);
            if (anchor != null) {
                GuideMEProxy.instance().openGuide(player, packet.guideId(), anchor);
            } else {
                GuideMEProxy.instance().openGuide(player, packet.guideId());
            }
        });
    }

    public void sendPacket(PacketDistributor.PacketTarget target, OpenGuideRequest request) {
        this.networkChannel.send(target, (Object)request);
    }

    public static ResourceLocation makeId(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static GuideME instance() {
        return Objects.requireNonNull(INSTANCE, "instance");
    }
}

