/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.inventory.InventorySearcherMenu;
import me.desht.pneumaticcraft.common.item.GPSAreaToolItem;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class InventorySearcherScreen
extends AbstractContainerScreen<InventorySearcherMenu> {
    private final ItemStackHandler inventory = new ItemStackHandler(1);
    private final Screen parentScreen;
    private Predicate<ItemStack> stackPredicate = itemStack -> true;
    private WidgetLabel label;
    private int clickedMouseButton;

    public InventorySearcherScreen(InventorySearcherMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        inv.f_35978_.f_36096_ = container;
        this.f_97727_ = 176;
        this.parentScreen = Minecraft.m_91087_().f_91080_;
        container.init((IItemHandler)this.inventory);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.label = new WidgetLabel(this.f_97735_ + 105, this.f_97736_ + 28, (Component)Component.m_237119_(), -12566400);
        this.m_142416_((GuiEventListener)this.label);
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_7379_() {
        if (this.parentScreen != null) {
            ClientUtils.closeContainerGui(this.parentScreen);
        } else {
            super.m_7379_();
        }
    }

    public void setStackPredicate(Predicate<ItemStack> predicate) {
        this.stackPredicate = predicate;
    }

    @Nonnull
    public ItemStack getSearchStack() {
        return this.inventory.getStackInSlot(0);
    }

    public void setSearchStack(@Nonnull ItemStack stack) {
        if (!stack.m_41619_() && this.stackPredicate.test(stack)) {
            this.inventory.setStackInSlot(0, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType clickType) {
        if (slot != null) {
            if (slot.f_40219_ == 36) {
                this.clickedMouseButton = 0;
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                this.clickedMouseButton = mouseButton;
                this.setSearchStack(slot.m_7993_());
            }
        }
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.inventory.getStackInSlot(0).m_41720_() instanceof IPositionProvider) {
            this.label.m_93666_((Component)Component.m_237113_((String)PneumaticCraftUtils.posToString(this.getBlockPos())));
        } else {
            this.label.m_93666_((Component)Component.m_237119_());
        }
    }

    public BlockPos getBlockPos() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.m_41720_() instanceof IPositionProvider) {
            List<BlockPos> posList = ((IPositionProvider)stack.m_41720_()).getRawStoredPositions(ClientUtils.getClientPlayer(), stack);
            int posIdx = this.getPosIdx(stack);
            if (!posList.isEmpty()) {
                return posList.get(Math.min(posIdx, posList.size() - 1));
            }
        }
        return null;
    }

    private int getPosIdx(ItemStack stack) {
        if (stack.m_41720_() instanceof GPSAreaToolItem) {
            return switch (this.clickedMouseButton) {
                case 0 -> 1;
                case 1 -> 0;
                default -> 1;
            };
        }
        return this.clickedMouseButton;
    }

    protected void m_7286_(GuiGraphics graphics, float par1, int par2, int par3) {
        this.m_280273_(graphics);
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(Textures.GUI_INVENTORY_SEARCHER, xStart, yStart, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.m_96636_(), this.f_96543_ / 2, 5, 0x404040, false);
        for (int i = 0; i < ((InventorySearcherMenu)this.f_97732_).f_38839_.size() - 1; ++i) {
            Slot slot = (Slot)((InventorySearcherMenu)this.f_97732_).f_38839_.get(i);
            if (this.stackPredicate.test(slot.m_7993_())) continue;
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            graphics.m_280024_(slot.f_40220_, slot.f_40221_, slot.f_40220_ + 16, slot.f_40221_ + 16, -1071636448, -1071636448);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    public void m_88315_(GuiGraphics graphics, int par1, int par2, float par3) {
        super.m_88315_(graphics, par1, par2, par3);
        if (this.f_97734_ != null && this.stackPredicate.test(this.f_97734_.m_7993_())) {
            this.m_280072_(graphics, par1, par2);
        }
    }
}

