/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class AreaTypePyramid
extends AreaType {
    public static final String ID = "pyramid";
    private AreaType.EnumAxis axis = AreaType.EnumAxis.X;
    private EnumAreaTypePyramid pyramidType = EnumAreaTypePyramid.FILLED;

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                if (p2.m_123341_() == p1.m_123341_()) break;
                Vec3 lineVec = new Vec3((double)(p2.m_123341_() - p1.m_123341_()), (double)(p2.m_123342_() - p1.m_123342_()), (double)(p2.m_123343_() - p1.m_123343_())).m_82541_();
                lineVec = new Vec3(lineVec.f_82479_, lineVec.f_82480_ / lineVec.f_82479_, lineVec.f_82481_ / lineVec.f_82479_);
                double curY = (double)p1.m_123342_() - lineVec.f_82480_;
                int x = p1.m_123341_() + (p2.m_123341_() > p1.m_123341_() ? -1 : 1);
                double curZ = (double)p1.m_123343_() - lineVec.f_82481_;
                int prevDY = -1;
                int prevDZ = -1;
                while (x != p2.m_123341_()) {
                    x += p2.m_123341_() > p1.m_123341_() ? 1 : -1;
                    int dY = Math.abs((int)((curY += lineVec.f_82480_) - (double)p1.m_123342_()));
                    int dZ = Math.abs((int)((curZ += lineVec.f_82481_) - (double)p1.m_123343_()));
                    if (dY == prevDY) {
                        --prevDY;
                    }
                    if (dZ == prevDZ) {
                        --prevDZ;
                    }
                    for (int y = p1.m_123342_() - dY; y <= p1.m_123342_() + dY; ++y) {
                        for (int z = p1.m_123343_() - dZ; z <= p1.m_123343_() + dZ; ++z) {
                            if (this.pyramidType != EnumAreaTypePyramid.FILLED && x != p2.m_123341_() && z >= p1.m_123343_() - prevDZ && z <= p1.m_123343_() + prevDZ && y >= p1.m_123342_() - prevDY && y <= p1.m_123342_() + prevDY) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                    prevDY = dY;
                    prevDZ = dZ;
                }
                break;
            }
            case Y: {
                if (p2.m_123342_() == p1.m_123342_()) break;
                Vec3 lineVec = new Vec3((double)(p2.m_123341_() - p1.m_123341_()), (double)(p2.m_123342_() - p1.m_123342_()), (double)(p2.m_123343_() - p1.m_123343_())).m_82541_();
                lineVec = new Vec3(lineVec.f_82479_ / lineVec.f_82480_, lineVec.f_82480_, lineVec.f_82481_ / lineVec.f_82480_);
                double curX = (double)p1.m_123341_() - lineVec.f_82479_;
                int y = p1.m_123342_() + (p2.m_123342_() > p1.m_123342_() ? -1 : 1);
                double curZ = (double)p1.m_123343_() - lineVec.f_82481_;
                int prevDX = -1;
                int prevDZ = -1;
                while (y != p2.m_123342_()) {
                    y += p2.m_123342_() > p1.m_123342_() ? 1 : -1;
                    int dX = Math.abs((int)((curX += lineVec.f_82479_) - (double)p1.m_123341_()));
                    int dZ = Math.abs((int)((curZ += lineVec.f_82481_) - (double)p1.m_123343_()));
                    if (dX == prevDX) {
                        --prevDX;
                    }
                    if (dZ == prevDZ) {
                        --prevDZ;
                    }
                    int miniX = p1.m_123341_() - dX;
                    int maxiX = p1.m_123341_() + dX;
                    int miniZ = p1.m_123343_() - dZ;
                    int maxiZ = p1.m_123343_() + dZ;
                    for (int x = miniX; x <= maxiX; ++x) {
                        for (int z = miniZ; z <= maxiZ; ++z) {
                            if (this.pyramidType != EnumAreaTypePyramid.FILLED && y != p2.m_123342_() && z >= p1.m_123343_() - prevDZ && z <= p1.m_123343_() + prevDZ && x >= p1.m_123341_() - prevDX && x <= p1.m_123341_() + prevDX) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                    prevDX = dX;
                    prevDZ = dZ;
                }
                break;
            }
            case Z: {
                if (p2.m_123343_() == p1.m_123343_()) break;
                Vec3 lineVec = new Vec3((double)(p2.m_123341_() - p1.m_123341_()), (double)(p2.m_123342_() - p1.m_123342_()), (double)(p2.m_123343_() - p1.m_123343_())).m_82541_();
                lineVec = new Vec3(lineVec.f_82479_ / lineVec.f_82481_, lineVec.f_82480_ / lineVec.f_82481_, lineVec.f_82481_);
                double curX = (double)p1.m_123341_() - lineVec.f_82479_;
                int z = p1.m_123343_() + (p2.m_123343_() > p1.m_123343_() ? -1 : 1);
                double curY = (double)p1.m_123342_() - lineVec.f_82480_;
                int prevDX = -1;
                int prevDY = -1;
                while (z != p2.m_123343_()) {
                    z += p2.m_123343_() > p1.m_123343_() ? 1 : -1;
                    int dX = Math.abs((int)((curX += lineVec.f_82479_) - (double)p1.m_123341_()));
                    int dY = Math.abs((int)((curY += lineVec.f_82480_) - (double)p1.m_123342_()));
                    if (dX == prevDX) {
                        --prevDX;
                    }
                    if (dY == prevDY) {
                        --prevDY;
                    }
                    for (int x = p1.m_123341_() - dX; x <= p1.m_123341_() + dX; ++x) {
                        for (int y = p1.m_123342_() - dY; y <= p1.m_123342_() + dY; ++y) {
                            if (this.pyramidType != EnumAreaTypePyramid.FILLED && z != p2.m_123343_() && x >= p1.m_123341_() - prevDX && x <= p1.m_123341_() + prevDX && y >= p1.m_123342_() - prevDY && y <= p1.m_123342_() + prevDY) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                    prevDX = dX;
                    prevDY = dY;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.axis.toString());
            }
        }
    }

    public AreaTypePyramid() {
        super(ID);
    }

    public String toString() {
        return this.getName() + "/" + String.valueOf(this.pyramidType) + "/" + String.valueOf(this.axis);
    }

    @Override
    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldAreaType, int typeInfo) {
        switch (oldAreaType) {
            case X_PYRAMID: {
                this.axis = AreaType.EnumAxis.X;
                break;
            }
            case Y_PYRAMID: {
                this.axis = AreaType.EnumAxis.Y;
                break;
            }
            case Z_PYRAMID: {
                this.axis = AreaType.EnumAxis.Z;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetEnum<AreaType.EnumAxis>("pneumaticcraft.gui.progWidget.area.type.general.axis", AreaType.EnumAxis.class, () -> this.axis, axis -> {
            this.axis = axis;
        }));
        widgets.add(new AreaType.AreaTypeWidgetEnum<EnumAreaTypePyramid>("pneumaticcraft.gui.progWidget.area.type.pyramid.pyramidType", EnumAreaTypePyramid.class, () -> this.pyramidType, pyramidType -> {
            this.pyramidType = pyramidType;
        }));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128344_("axis", (byte)this.axis.ordinal());
        tag.m_128344_("pyramidType", (byte)this.pyramidType.ordinal());
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.axis = AreaType.EnumAxis.values()[tag.m_128445_("axis")];
        this.pyramidType = EnumAreaTypePyramid.values()[tag.m_128445_("pyramidType")];
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        buffer.writeByte(this.axis.ordinal());
        buffer.writeByte(this.pyramidType.ordinal());
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.axis = AreaType.EnumAxis.values()[buf.readByte()];
        this.pyramidType = EnumAreaTypePyramid.values()[buf.readByte()];
    }

    private static enum EnumAreaTypePyramid implements ITranslatableEnum
    {
        FILLED("filled"),
        HOLLOW("hollow");

        private final String name;

        private EnumAreaTypePyramid(String name) {
            this.name = "pneumaticcraft.gui.progWidget.area.type.pyramid.pyramidType." + name;
        }

        @Override
        public String getTranslationKey() {
            return this.name;
        }
    }
}

