/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.IDescSynced;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.SyncedField;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketDescription
extends LocationIntPacket {
    private final boolean fullSync;
    private final List<IndexedField> fields = new ArrayList<IndexedField>();
    private final CompoundTag extraData;

    public PacketDescription(IDescSynced te, boolean fullSync) {
        super(te.getPosition());
        this.fullSync = fullSync;
        List<SyncedField<?>> descFields = te.getDescriptionFields();
        for (int i = 0; i < descFields.size(); ++i) {
            if (!fullSync && !te.shouldSyncField(i)) continue;
            this.fields.add(new IndexedField(i, SyncedField.getType(descFields.get(i)), descFields.get(i).getValue()));
        }
        this.extraData = new CompoundTag();
        te.writeToPacket(this.extraData);
    }

    public PacketDescription(FriendlyByteBuf buf) {
        super(buf);
        this.fullSync = buf.readBoolean();
        int fieldCount = buf.m_130242_();
        for (int i = 0; i < fieldCount; ++i) {
            int idx = this.fullSync ? i : buf.m_130242_();
            byte type = buf.readByte();
            this.fields.add(new IndexedField(idx, type, SyncedField.fromBytes(buf, type)));
        }
        this.extraData = buf.m_130260_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.fullSync);
        buf.m_130130_(this.fields.size());
        for (IndexedField indexedField : this.fields) {
            if (!this.fullSync) {
                buf.m_130130_(indexedField.idx);
            }
            buf.writeByte((int)indexedField.type);
            SyncedField.toBytes(buf, indexedField.value, indexedField.type);
        }
        buf.m_130079_(this.extraData);
    }

    public void process(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.processPacket(null));
        ctx.get().setPacketHandled(true);
    }

    public void processPacket(BlockEntity blockEntity) {
        if (blockEntity == null) {
            if (!ClientUtils.getClientLevel().m_46749_(this.pos)) {
                return;
            }
            blockEntity = ClientUtils.getBlockEntity(this.pos);
        }
        if (blockEntity instanceof IDescSynced) {
            IDescSynced descSynced = (IDescSynced)blockEntity;
            List<SyncedField<?>> descFields = descSynced.getDescriptionFields();
            if (descFields != null) {
                for (IndexedField indexedField : this.fields) {
                    if (indexedField.idx >= descFields.size()) continue;
                    descFields.get(indexedField.idx).setValue(indexedField.value);
                }
            }
            descSynced.readFromPacket(this.extraData);
            descSynced.onDescUpdate();
        }
    }

    public CompoundTag writeNBT(CompoundTag compound) {
        CompoundTag subTag = new CompoundTag();
        subTag.m_128405_("Length", this.fields.size());
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        ListTag list = new ListTag();
        for (IndexedField field : this.fields) {
            CompoundTag element = new CompoundTag();
            element.m_128344_("Type", field.type);
            buf.clear();
            SyncedField.toBytes(buf, field.value, field.type);
            element.m_128382_("Value", Arrays.copyOf(buf.array(), buf.writerIndex()));
            list.add(list.size(), (Tag)element);
        }
        buf.release();
        subTag.m_128365_("Data", (Tag)list);
        subTag.m_128365_("Extra", (Tag)this.extraData);
        compound.m_128365_("pneumaticcraft", (Tag)subTag);
        return compound;
    }

    public PacketDescription(CompoundTag compound) {
        super(new BlockPos(compound.m_128451_("x"), compound.m_128451_("y"), compound.m_128451_("z")));
        this.fullSync = true;
        CompoundTag subTag = compound.m_128469_("pneumaticcraft");
        int fieldCount = subTag.m_128451_("Length");
        ListTag list = subTag.m_128437_("Data", 10);
        for (int i = 0; i < fieldCount; ++i) {
            CompoundTag element = list.m_128728_(i);
            byte type = element.m_128445_("Type");
            byte[] b = element.m_128463_("Value");
            this.fields.add(new IndexedField(i, type, SyncedField.fromBytes(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])b)), type)));
        }
        this.extraData = subTag.m_128469_("Extra");
    }

    public boolean hasData() {
        return !this.fields.isEmpty() || !this.extraData.m_128456_();
    }

    private record IndexedField(int idx, byte type, Object value) {
    }
}

