/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.core.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.managers.machine.PulverizerRecipeManager;
import cofh.thermal.core.util.recipes.machine.PulverizerRecipe;
import cofh.thermal.expansion.client.gui.machine.MachinePulverizerScreen;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;

public class PulverizerRecipeCategory
extends ThermalRecipeCategory<PulverizerRecipe> {
    public PulverizerRecipeCategory(IGuiHelper guiHelper, ItemStack icon, RecipeType<PulverizerRecipe> type) {
        super(guiHelper, icon, type);
        this.energyMod = () -> Float.valueOf(PulverizerRecipeManager.instance().getDefaultScale());
        this.background = guiHelper.drawableBuilder(MachinePulverizerScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)((Block)ThermalCore.BLOCKS.get("machine_pulverizer")).m_7705_());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(0);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(3);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(0), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(3), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public RecipeType<PulverizerRecipe> getRecipeType() {
        return this.type;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PulverizerRecipe recipe, IFocusGroup focuses) {
        List inputs = recipe.getInputItems();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(recipe.getOutputItems().size());
        List catalysts = PulverizerRecipeManager.instance().getCatalysts();
        for (ItemStack stack : recipe.getOutputItems()) {
            outputs.add(ItemHelper.cloneStack((ItemStack)stack));
        }
        for (int i = 0; i < outputs.size(); ++i) {
            float chance = ((Float)recipe.getOutputItemChances().get(i)).floatValue();
            if (!(chance > 1.0f)) continue;
            ((ItemStack)outputs.get(i)).m_41764_((int)chance);
        }
        IRecipeSlotBuilder[] outputSlots = new IRecipeSlotBuilder[4];
        builder.addSlot(RecipeIngredientRole.INPUT, 34, 6).addIngredients((Ingredient)inputs.get(0));
        IRecipeSlotBuilder catalystSlot = builder.addSlot(RecipeIngredientRole.INPUT, 34, 42);
        if (recipe.isCatalyzable()) {
            ((IRecipeSlotBuilder)catalystSlot.addItemStacks(catalysts)).addTooltipCallback(TCoreJeiPlugin.catalystTooltip());
        }
        outputSlots[0] = builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 15);
        outputSlots[1] = builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 15);
        outputSlots[2] = builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 33);
        outputSlots[3] = builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 33);
        for (int i = 0; i < outputs.size(); ++i) {
            ((IRecipeSlotBuilder)outputSlots[i].addItemStack((ItemStack)outputs.get(i))).addTooltipCallback(TCoreJeiPlugin.catalyzedOutputTooltip((float)((Float)recipe.getOutputItemChances().get(i)).floatValue(), (boolean)recipe.isCatalyzable()));
        }
    }

    public void draw(PulverizerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.progressBackground.draw(guiGraphics, 62, 24);
        this.speedBackground.draw(guiGraphics, 34, 24);
        this.progress.draw(guiGraphics, 62, 24);
        this.speed.draw(guiGraphics, 34, 24);
    }
}

