/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.mojang.serialization.Codec;
import dan200.computercraft.data.BlockModelProvider;
import dan200.computercraft.data.ItemModelProvider;
import dan200.computercraft.data.LanguageProvider;
import dan200.computercraft.data.LootTableProvider;
import dan200.computercraft.data.ModelProvider;
import dan200.computercraft.data.PocketUpgradeProvider;
import dan200.computercraft.data.RecipeProvider;
import dan200.computercraft.data.TagProvider;
import dan200.computercraft.data.TurtleUpgradeProvider;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class DataProviders {
    private DataProviders() {
    }

    public static void add(GeneratorSink generator) {
        TurtleUpgradeProvider turtleUpgrades = (TurtleUpgradeProvider)generator.add(TurtleUpgradeProvider::new);
        PocketUpgradeProvider pocketUpgrades = (PocketUpgradeProvider)generator.add(PocketUpgradeProvider::new);
        generator.add(out -> new RecipeProvider(out, turtleUpgrades, pocketUpgrades));
        TagsProvider<Block> blockTags = generator.blockTags(TagProvider::blockTags);
        generator.itemTags(TagProvider::itemTags, blockTags);
        generator.add(out -> new net.minecraft.data.loot.LootTableProvider(out, Set.of(), LootTableProvider.getTables()));
        generator.add(out -> new ModelProvider(out, BlockModelProvider::addBlockModels, ItemModelProvider::addItemModels));
        generator.add(out -> new LanguageProvider(out, turtleUpgrades, pocketUpgrades));
        try {
            Class.forName("dan200.computercraft.data.client.ClientDataProviders").getMethod("add", GeneratorSink.class).invoke(null, generator);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface GeneratorSink {
        public <T extends DataProvider> T add(DataProvider.Factory<T> var1);

        public <T> void addFromCodec(String var1, PackType var2, String var3, Codec<T> var4, Consumer<BiConsumer<ResourceLocation, T>> var5);

        public TagsProvider<Block> blockTags(Consumer<TagProvider.TagConsumer<Block>> var1);

        public TagsProvider<Item> itemTags(Consumer<TagProvider.ItemTagConsumer> var1, TagsProvider<Block> var2);
    }
}

