/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.util.DirectionUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TurtlePlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TurtlePlayer.class);
    private static final GameProfile DEFAULT_PROFILE = new GameProfile(UUID.fromString("0d0c4ca0-4ff1-11e4-916c-0800200c9a66"), "[ComputerCraft]");
    private final ServerPlayer player;

    private TurtlePlayer(ServerPlayer player) {
        this.player = player;
    }

    private static TurtlePlayer create(ITurtleAccess turtle) {
        ServerLevel world = (ServerLevel)turtle.getLevel();
        GameProfile profile = turtle.getOwningPlayer();
        TurtlePlayer player = new TurtlePlayer(PlatformHelper.get().createFakePlayer(world, TurtlePlayer.getProfile(profile)));
        player.setState(turtle);
        return player;
    }

    private static GameProfile getProfile(@Nullable GameProfile profile) {
        return profile != null && profile.isComplete() ? profile : DEFAULT_PROFILE;
    }

    public static TurtlePlayer get(ITurtleAccess access) {
        if (!(access instanceof TurtleBrain)) {
            throw new IllegalStateException("ITurtleAccess is not a brain");
        }
        TurtleBrain brain = (TurtleBrain)access;
        TurtlePlayer player = brain.cachedPlayer;
        if (player == null || player.player.m_36316_() != TurtlePlayer.getProfile(access.getOwningPlayer()) || player.player.m_9236_() != access.getLevel()) {
            player = brain.cachedPlayer = TurtlePlayer.create(brain);
        } else {
            player.setState(access);
        }
        return player;
    }

    public static TurtlePlayer getWithPosition(ITurtleAccess turtle, BlockPos position, Direction direction) {
        TurtlePlayer turtlePlayer = TurtlePlayer.get(turtle);
        turtlePlayer.setPosition(turtle, position, direction);
        return turtlePlayer;
    }

    public ServerPlayer player() {
        return this.player;
    }

    private void setRotation(float y, float x) {
        this.player.m_146922_(y);
        this.player.m_146926_(x);
    }

    private void setState(ITurtleAccess turtle) {
        if (this.player.f_36096_ != this.player.f_36095_) {
            LOGGER.warn("Turtle has open container ({})", (Object)this.player.f_36096_);
            this.player.m_9230_();
        }
        BlockPos position = turtle.getPosition();
        this.player.m_20343_((double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5);
        this.setRotation(turtle.getDirection().m_122435_(), 0.0f);
        this.player.m_150109_().m_6211_();
    }

    public void setPosition(ITurtleAccess turtle, BlockPos position, Direction direction) {
        double posX = (double)position.m_123341_() + 0.5;
        double posY = (double)position.m_123342_() + 0.5;
        double posZ = (double)position.m_123343_() + 0.5;
        if (turtle.getPosition().equals((Object)position)) {
            posX += 0.48 * (double)direction.m_122429_();
            posY += 0.48 * (double)direction.m_122430_();
            posZ += 0.48 * (double)direction.m_122431_();
        }
        if (direction.m_122434_() != Direction.Axis.Y) {
            this.setRotation(direction.m_122435_(), 0.0f);
        } else {
            this.setRotation(turtle.getDirection().m_122435_(), DirectionUtil.toPitchAngle(direction));
        }
        this.player.m_20343_(posX, posY, posZ);
        this.player.f_19854_ = posX;
        this.player.f_19855_ = posY;
        this.player.f_19856_ = posZ;
        this.player.f_19860_ = this.player.m_146909_();
        this.player.f_20885_ = this.player.f_19859_ = this.player.m_146908_();
        this.player.f_20886_ = this.player.f_19859_;
    }

    public void loadInventory(ItemStack stack) {
        this.player.m_150109_().m_6211_();
        this.player.m_150109_().f_35977_ = 0;
        this.player.m_150109_().m_6836_(0, stack);
    }

    public void loadInventory(ITurtleAccess turtle) {
        Inventory inventory = this.player.m_150109_();
        Container turtleInventory = turtle.getInventory();
        int currentSlot = turtle.getSelectedSlot();
        int slots = turtleInventory.m_6643_();
        inventory.f_35977_ = 0;
        for (int i = 0; i < slots; ++i) {
            inventory.m_6836_(i, turtleInventory.m_8020_((currentSlot + i) % slots));
        }
    }

    public void unloadInventory(ITurtleAccess turtle) {
        if (this.player.m_6117_()) {
            this.player.m_5810_();
        }
        Inventory inventory = this.player.m_150109_();
        Container turtleInventory = turtle.getInventory();
        int currentSlot = turtle.getSelectedSlot();
        int slots = turtleInventory.m_6643_();
        inventory.f_35977_ = 0;
        for (int i = 0; i < slots; ++i) {
            turtleInventory.m_6836_((currentSlot + i) % slots, inventory.m_8020_(i));
        }
        int totalSize = inventory.m_6643_();
        for (int i = slots; i < totalSize; ++i) {
            TurtleUtil.storeItemOrDrop(turtle, inventory.m_8020_(i));
        }
        inventory.m_6596_();
    }

    public boolean isBlockProtected(ServerLevel level, BlockPos pos) {
        return level.m_7654_().m_7762_(level, pos, (Player)this.player);
    }
}

