/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.items.ModuleItem;
import com.brandon3055.draconicevolution.api.modules.lib.InstallResult;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ModuleGridRenderer
extends GuiElement<ModuleGridRenderer>
implements BackgroundRender {
    private ModuleGrid grid;
    private Inventory player;
    private boolean doubleClick;
    private long lastClickTime;
    private int lastClickButton;
    private boolean canDrop = false;
    private ModuleGrid.GridPos lastClickPos;
    private List<Component> lastError = null;
    private int lastErrorTime = 0;
    public boolean renderBorder = true;
    private ModuleGrid.GridPos hoverCell = null;
    private int hoverTime = 0;

    public ModuleGridRenderer(@NotNull GuiParent<?> parent, ModuleGrid grid, Inventory player) {
        super(parent);
        this.grid = grid;
        this.player = player;
        this.constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)(grid.getWidth() * grid.getCellSize())));
        this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)(grid.getHeight() * grid.getCellSize())));
        this.setTooltip(() -> this.lastError == null ? Collections.emptyList() : this.lastError);
        this.setTooltipDelay(0);
        this.getModularGui().setFloatingItemDisablesToolTips(false);
    }

    public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        int light = GuiToolkit.Palette.BG.accentLight();
        int dark = GuiToolkit.Palette.BG.accentDark();
        int fill = GuiToolkit.Palette.BG.fill();
        if (this.renderBorder) {
            render.shadedRect(this.xMin() - 2.0, this.yMin() - 2.0, this.xSize() + 4.0, this.ySize() + 4.0, 1.0, light, dark, fill);
            render.shadedRect(this.xMin() - 1.0, this.yMin() - 1.0, this.xSize() + 2.0, this.ySize() + 2.0, 1.0, dark, light, fill);
        }
        render.rect(this.xMin(), this.yMin(), this.xSize(), this.ySize(), GuiRender.midColour((int)light, (int)dark));
        int s = this.grid.getCellSize();
        for (int x = 0; x < this.grid.getWidth(); ++x) {
            for (int y = 0; y < this.grid.getHeight(); ++y) {
                int xPos = (int)this.xMin() + x * s;
                int yPos = (int)this.yMin() + y * s;
                this.renderCell(render, xPos, yPos, s, x, y, mouseX, mouseY, GuiRender.isInRect((int)xPos, (int)yPos, (int)s, (int)s, (double)mouseX, (double)mouseY), partialTicks);
            }
        }
    }

    public boolean renderOverlay(GuiRender render, double mouseX, double mouseY, float partialTicks, boolean consumed) {
        if (consumed) {
            return super.renderOverlay(render, mouseX, mouseY, partialTicks, consumed);
        }
        for (ModuleEntity<ModuleGridRenderer> moduleEntity : this.grid.getModuleHost().getModuleEntities()) {
            int y;
            int cs = this.grid.getCellSize();
            int mw = moduleEntity.getWidth() * cs;
            int mh = moduleEntity.getHeight() * cs;
            int x = (int)this.xMin() + moduleEntity.getGridX() * cs;
            boolean mouseOver = GuiRender.isInRect((int)x, (int)(y = (int)this.yMin() + moduleEntity.getGridY() * cs), (int)mw, (int)mh, (double)mouseX, (double)mouseY) && this.isMouseOver();
            if (!moduleEntity.renderModuleOverlay(this, this.grid.container.getModuleContext(), render, x, y, mw, mh, mouseX, mouseY, partialTicks, mouseOver ? this.hoverTime : 0)) continue;
            return true;
        }
        return super.renderOverlay(render, mouseX, mouseY, partialTicks, consumed);
    }

    public void renderCell(GuiRender render, int x, int y, int size, int cellX, int cellY, double mouseX, double mouseY, boolean mouseOver, float partialTicks) {
        ModuleGrid.GridPos cell = this.grid.getCell(cellX, cellY);
        if (cell.hasEntity()) {
            ModuleEntity<ModuleGridRenderer> entity = cell.getEntity();
            int cs = this.grid.getCellSize();
            int mw = entity.getWidth() * cs;
            int mh = entity.getHeight() * cs;
            if (cell.isActualEntityPos()) {
                entity.renderModule(this, render, x, y, mw, mh, mouseX, mouseY, false, partialTicks);
            }
        } else {
            render.rect((double)(x + 1), (double)(y + 1), (double)(size - 2), (double)(size - 2), BCConfig.darkMode ? -8355712 : -11513776);
            if (mouseOver) {
                render.rect((double)x, (double)y, (double)size, (double)size, 0x50FFFFFF);
            }
        }
    }

    public boolean renderStackOverride(GuiRender render, ItemStack stack, int x, int y, String altText) {
        Module<?> module;
        x += 8;
        y += 8;
        if (this.isMouseOver() && (module = ModuleItem.getModule(stack)) != null) {
            ModuleEntity<ModuleGridRenderer> entity = module.createEntity();
            int cs = this.grid.getCellSize();
            int mw = module.getProperties().getWidth() * cs;
            int mh = module.getProperties().getHeight() * cs;
            render.pose().m_85836_();
            entity.renderModule(this, render, x - mw / 2, y - mh / 2, mw, mh, x, y, true, this.mc().m_91297_());
            if (stack.m_41613_() > 1 || altText != null) {
                String s = altText == null ? String.valueOf(stack.m_41613_()) : altText;
                double d = (float)(x - this.font().m_92895_(s)) + (float)mw / 2.0f + 1.0f;
                Objects.requireNonNull(this.font());
                render.drawString(s, d, (double)((float)(y - 9) + (float)mh / 2.0f + 2.0f), 0xFFFFFF, true);
            }
            render.pose().m_85849_();
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.canDrop = false;
        this.lastError = null;
        if (this.isMouseOver()) {
            Screen screen = this.getModularGui().getScreen();
            if (screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                containerScreen.f_97719_ = true;
            }
            InputConstants.Key mouseKey = InputConstants.Type.MOUSE.m_84895_(button);
            boolean pickBlock = this.mc().f_91066_.f_92097_.isActiveAndMatches(mouseKey);
            ModuleGrid.GridPos cell = this.getCellAtPos(mouseX, mouseY, true);
            long i = Util.m_137550_();
            boolean bl = this.doubleClick = i - this.lastClickTime < 250L && this.lastClickButton == button && this.getCellAtPos(mouseX, mouseY, false).equals(this.lastClickPos);
            if (cell.isValidCell()) {
                ModuleEntity<ModuleGridRenderer> entity = cell.getEntity();
                if (entity != null) {
                    int yPos;
                    int cs = this.grid.getCellSize();
                    int mw = entity.getWidth() * cs;
                    int mh = entity.getHeight() * cs;
                    int xPos = (int)this.xMin() + entity.getGridX() * cs;
                    if (entity.clientModuleClicked(this, this.player.f_35978_, xPos, yPos = (int)this.yMin() + entity.getGridY() * cs, mw, mh, mouseX, mouseY, button)) {
                        return true;
                    }
                }
                if (this.player.f_35978_.f_36096_.m_142621_().m_41619_()) {
                    if (pickBlock) {
                        this.handleGridClick(cell, mouseX, mouseY, button, ClickType.CLONE);
                    } else {
                        boolean shiftClick = InputConstants.m_84830_((long)this.mc().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)this.mc().m_91268_().m_85439_(), (int)344);
                        ClickType clicktype = ClickType.PICKUP;
                        if (shiftClick) {
                            clicktype = ClickType.QUICK_MOVE;
                        }
                        this.handleGridClick(cell, mouseX, mouseY, button, clicktype);
                    }
                } else {
                    this.canDrop = true;
                }
            }
            this.lastClickTime = i;
            this.lastClickPos = this.getCellAtPos(mouseX, mouseY, false);
            this.lastClickButton = button;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        ModuleGrid.GridPos cell = this.getCellAtPos(mouseX, mouseY, true);
        if (this.doubleClick && button == 0) {
            this.handleGridClick(cell, mouseX, mouseY, button, ClickType.PICKUP_ALL);
            this.doubleClick = false;
            this.lastClickTime = 0L;
        } else if (this.canDrop) {
            this.handleGridClick(cell, mouseX, mouseY, button, ClickType.PICKUP);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected void handleGridClick(ModuleGrid.GridPos cell, double mouseX, double mouseY, int mouseButton, ClickType type) {
        float x = 0.5f;
        float y = 0.5f;
        ModuleEntity<?> entity = cell.getEntity();
        if (entity != null) {
            int cs = this.grid.getCellSize();
            int mw = entity.getWidth() * cs;
            int mh = entity.getHeight() * cs;
            int mx = (int)this.xMin() + entity.getGridX() * cs;
            int my = (int)this.xMin() + entity.getGridY() * cs;
            x = (float)(mouseX - (double)mx) / (float)mw;
            y = (float)(mouseY - (double)my) / (float)mh;
        }
        DraconicNetwork.sendModuleContainerClick(cell, x, y, mouseButton, type);
        InstallResult result = this.grid.cellClicked(cell, x, y, mouseButton, type);
        if (result != null && result.resultType != InstallResult.InstallResultType.YES && result.resultType != InstallResult.InstallResultType.OVERRIDE) {
            this.lastError = result.reason;
            this.lastErrorTime = 0;
        }
    }

    private ModuleGrid.GridPos getCellAtPos(double xPos, double yPos, boolean withPlaceOffset) {
        int cs = this.grid.getCellSize();
        int x = (int)((xPos - this.xMin()) / (double)cs);
        int y = (int)((yPos - this.yMin()) / (double)cs);
        Module<?> module = ModuleItem.getModule(this.player.f_35978_.f_36096_.m_142621_());
        if (module != null && withPlaceOffset) {
            int mw = module.getProperties().getWidth() * cs;
            int mh = module.getProperties().getHeight() * cs;
            x = (int)((xPos - this.xMin() - (double)mw / 2.0 + (double)cs / 2.0) / (double)cs);
            y = (int)((yPos - this.yMin() - (double)mh / 2.0 + (double)cs / 2.0) / (double)cs);
        }
        return this.grid.getCell(x, y);
    }

    public void tick(double mouseX, double mouseY) {
        ModuleGrid.GridPos cell = this.getCellAtPos(mouseX, mouseY, false);
        if (cell.hasEntity()) {
            ModuleEntity<?> entity = cell.getEntity();
            if ((cell = this.grid.getCell(entity.getGridX(), entity.getGridY())).equals(this.hoverCell)) {
                ++this.hoverTime;
            } else {
                this.hoverTime = 0;
                this.hoverCell = cell;
            }
        } else {
            this.hoverTime = 0;
        }
        if (this.lastError != null && this.lastErrorTime++ > 100) {
            this.lastError = null;
        }
        super.tick(mouseX, mouseY);
    }
}

