/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.ModularGuiContainer;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiScrolling;
import codechicken.lib.gui.modular.elements.GuiSlider;
import codechicken.lib.gui.modular.elements.GuiSlots;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.container.ContainerGuiProvider;
import codechicken.lib.gui.modular.lib.container.ContainerScreenAccess;
import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.Direction;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.lib.geometry.Position;
import codechicken.lib.gui.modular.sprite.Material;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.HudConfigGui;
import com.brandon3055.brandonscore.client.gui.InfoPanel;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.ButtonRow;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.client.gui.ModuleGridRenderer;
import com.brandon3055.draconicevolution.client.gui.modular.SupportedModulesIcon;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.inventory.ModularItemMenu;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ModularItemGui
extends ContainerGuiProvider<ModularItemMenu> {
    public static final GuiToolkit TOOLKIT = new GuiToolkit("gui.draconicevolution.modular_item");
    private static AtomicBoolean infoExpanded = new AtomicBoolean(true);
    private ModuleGrid grid;
    private Inventory playerInv;
    private ModuleGridRenderer gridRenderer;
    private ModularItemMenu menu;
    private InfoPanel infoPanel;

    public GuiElement<?> createRootElement(ModularGui gui) {
        return new GuiTexture((GuiParent)gui, BCGuiTextures.themedGetter((String)"background_dynamic")).dynamicTexture();
    }

    public void buildGui(ModularGui gui, ContainerScreenAccess<ModularItemMenu> screenAccess) {
        this.menu = (ModularItemMenu)screenAccess.m_6262_();
        GuiElement root = gui.getRoot();
        this.grid = this.menu.getGrid();
        this.playerInv = this.menu.inventory;
        int maxGridWidth = 226;
        int maxGridHeight = 145;
        int minXPadding = 30;
        int yPadding = 112;
        int cellSize = Math.min(Math.min(maxGridWidth / this.grid.getWidth(), maxGridHeight / this.grid.getHeight()), 16);
        int width = Math.max(218, cellSize * this.grid.getWidth() + minXPadding);
        int height = yPadding + cellSize * this.grid.getHeight();
        this.grid.setCellSize(cellSize);
        gui.initStandardGui(width, height);
        GuiText title = TOOLKIT.createHeading((GuiParent)root, gui.getGuiTitle(), true);
        GuiSlots.PlayerAll playInv = GuiSlots.playerAllSlots((GuiParent)root, screenAccess, (SlotGroup)this.menu.main, (SlotGroup)this.menu.hotBar, (SlotGroup)this.menu.armor, (SlotGroup)this.menu.offhand);
        playInv.stream().forEach(e -> e.setSlotOverlay(this::renderSlotOverlay).setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")));
        Constraints.placeInside((ConstrainedGeometry)playInv.container(), (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)-7.0);
        this.setupCurioSlots(root, screenAccess);
        this.gridRenderer = new ModuleGridRenderer((GuiParent<?>)root, this.menu.getGrid(), this.playerInv);
        Constraints.placeOutside((ConstrainedGeometry)this.gridRenderer, (ConstrainedGeometry)title, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)3.0);
        this.grid.setPosition((int)(this.gridRenderer.xMin() - root.xMin()), (int)(this.gridRenderer.yMin() - root.yMin()));
        this.grid.setOnGridChange(this::updateInfoPanel);
        this.infoPanel = InfoPanel.create((GuiElement)root).setExpandedStateHolder(infoExpanded);
        ButtonRow leftButtons = ButtonRow.topLeftInside((GuiElement)root, (Direction)Direction.RIGHT, (int)3, (int)3).setSpacing(1.0);
        leftButtons.addButton(e -> (GuiElement)TOOLKIT.createThemedIconButton((GuiParent)e, "item_config").onPress(() -> DraconicNetwork.sendOpenItemConfig(false)).setTooltip(new Component[]{TOOLKIT.translate("open_item_config.info", new Object[0])}));
        leftButtons.addButton(e -> (GuiElement)TOOLKIT.createThemedIconButton((GuiParent)e, "hud_button").onPress(() -> gui.mc().m_91152_((net.minecraft.client.gui.screens.Screen)new HudConfigGui.Screen())).setTooltip(new Component[]{Component.m_237115_((String)"hud.draconicevolution.open_hud_config")}));
        ButtonRow rightButtons = ButtonRow.topRightInside((GuiElement)root, (Direction)Direction.DOWN, (int)3, (int)3).setSpacing(1.0);
        rightButtons.addButton(arg_0 -> ((GuiToolkit)TOOLKIT).createThemeButton(arg_0));
        rightButtons.addButton(e -> TOOLKIT.createInfoButton((GuiElement)e, this.infoPanel));
        rightButtons.addButton(e -> new SupportedModulesIcon((GuiParent<?>)e, this.menu.getModuleHost()));
        this.updateInfoPanel();
    }

    private void setupCurioSlots(GuiElement<?> root, ContainerScreenAccess<ModularItemMenu> screenAccess) {
        if (!EquipmentManager.equipModLoaded() || this.menu.curios.slots().isEmpty()) {
            return;
        }
        GuiTexture background = new GuiTexture(root, BCGuiTextures.themedGetter((String)"background_dynamic")).dynamicTexture();
        GuiScrolling scroll = new GuiScrolling(root);
        Constraints.bind((ConstrainedGeometry)scroll, (ConstrainedGeometry)background, (double)4.0);
        GuiSlots slots = (GuiSlots)((GuiSlots)new GuiSlots((GuiParent)scroll.getContentElement(), screenAccess, this.menu.curios, 1).setSlotOverlay(this::renderSlotOverlay).setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")).setEmptyIconI(i -> Material.fromRawTexture((ResourceLocation)EquipmentManager.getIcons((LivingEntity)this.menu.inventory.f_35978_).get((int)i))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)scroll.getContentElement().get(GeoParam.LEFT)))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)scroll.getContentElement().get(GeoParam.TOP)));
        background.constrain(GeoParam.WIDTH, (Constraint)Constraint.relative((GeoRef)slots.get(GeoParam.WIDTH), () -> scroll.hiddenSize(Axis.Y) > 0.0 ? 12.0 : 8.0));
        background.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> Math.min(root.ySize(), slots.ySize() + 8.0)));
        background.constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)-2.0));
        background.constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.TOP)));
        GuiSlider bar = (GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)new GuiSlider((GuiParent)background, Axis.Y).setEnabled(() -> scroll.hiddenSize(Axis.Y) > 0.0)).setSliderState(scroll.scrollState(Axis.Y)).setScrollableElement((GuiElement)slots).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)4.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.BOTTOM), (double)-4.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)slots.get(GeoParam.RIGHT), (double)1.0));
        bar.installSlider((GuiElement)new GuiRectangle((GuiParent)bar).fill(() -> BCConfig.darkMode ? -2130706433 : -1157627904)).bindSliderWidth().bindSliderLength();
    }

    private void updateInfoPanel() {
        this.infoPanel.clear();
        TechLevel techLevel = this.menu.getModuleHost().getHostTechLevel();
        MutableComponent label = Component.m_237113_((String)(this.grid.getWidth() + "x" + this.grid.getHeight())).m_130946_(" ").m_7220_((Component)techLevel.getDisplayName().m_6879_().m_130940_(techLevel.getTextColour())).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.draconicevolution.modular_item.module_grid"));
        this.infoPanel.label((Component)label);
        LinkedHashMap<Component, Component> nameStatMap = new LinkedHashMap<Component, Component>();
        this.grid.getModuleHost().addInformation(nameStatMap, this.menu.getModuleContext());
        for (Component name : nameStatMap.keySet()) {
            this.infoPanel.labeledValue((Component)name.m_6881_().m_130940_(ChatFormatting.GOLD), () -> ((Component)nameStatMap.get(name)).m_6881_().m_130940_(ChatFormatting.GRAY));
        }
    }

    private void renderSlotOverlay(Slot slot, Position pos, GuiRender render) {
        if (slot.m_6657_() && slot.m_7993_().getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            int y = slot.f_40221_;
            int x = slot.f_40220_;
            int light = -268971;
            int dark = -763643;
            render.shadedRect(pos.x() - 1.0, pos.y() - 1.0, 18.0, 18.0, 1.0, dark, light, 0);
            if (slot.m_7993_() == this.menu.hostStack) {
                render.borderRect(pos.x(), pos.y(), 16.0, 16.0, 1.0, 0x50FF0000, -65536);
            }
        }
    }

    public static class Screen
    extends ModularGuiContainer<ModularItemMenu> {
        public Screen(ModularItemMenu menu, Inventory inv, Component title) {
            super((AbstractContainerMenu)menu, inv, (ContainerGuiProvider)new ModularItemGui());
            this.getModularGui().setGuiTitle(title);
        }

        public void renderFloatingItem(GuiRender render, ItemStack itemStack, int x, int y, String string) {
            ModularItemGui gui = (ModularItemGui)this.modularGui.getProvider();
            if (!gui.gridRenderer.renderStackOverride(render, itemStack, x, y, string)) {
                super.renderFloatingItem(render, itemStack, x, y, string);
            }
        }
    }
}

