/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.key;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.client.key.IKeyHandler;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;

public class KeyRegistry
implements IKeyRegistry {
    private final Multimap<KeyMapping, IKeyHandler> keyHandlerMap = HashMultimap.create();

    public static KeyMapping newKeyMapping(ModBase mod, String name, int defaultKey) {
        String id = L10NHelpers.localize("key." + mod.getModId() + "." + name, new Object[0]);
        String category = L10NHelpers.localize("key.categories." + mod.getModId(), new Object[0]);
        return new KeyMapping(id, defaultKey, category);
    }

    @Override
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerKeyInput(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (KeyMapping kb : this.keyHandlerMap.keySet()) {
                while (kb.m_90859_()) {
                    this.fireKeyPressed(kb);
                }
            }
        }
    }

    private void fireKeyPressed(KeyMapping kb) {
        for (IKeyHandler h : this.keyHandlerMap.get((Object)kb)) {
            h.onKeyPressed(kb);
        }
    }

    @Override
    public void addKeyHandler(KeyMapping kb, IKeyHandler handler) {
        this.keyHandlerMap.put((Object)kb, (Object)handler);
    }
}

