/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.foundation.init.data.worldgen;

import cofh.lib.util.helpers.DatapackHelper;
import cofh.thermal.foundation.init.data.worldgen.TFndFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class TFndBiomeModifiers {
    public static final ResourceKey<BiomeModifier> APATITE_ORE = TFndBiomeModifiers.createKey("ore_apatite");
    public static final ResourceKey<BiomeModifier> CINNABAR_ORE = TFndBiomeModifiers.createKey("ore_cinnabar");
    public static final ResourceKey<BiomeModifier> NITER_ORE = TFndBiomeModifiers.createKey("ore_niter");
    public static final ResourceKey<BiomeModifier> SULFUR_ORE = TFndBiomeModifiers.createKey("ore_sulfur");
    public static final ResourceKey<BiomeModifier> LEAD_ORE = TFndBiomeModifiers.createKey("ore_lead");
    public static final ResourceKey<BiomeModifier> NICKEL_ORE = TFndBiomeModifiers.createKey("ore_nickel");
    public static final ResourceKey<BiomeModifier> SILVER_ORE = TFndBiomeModifiers.createKey("ore_silver");
    public static final ResourceKey<BiomeModifier> TIN_ORE = TFndBiomeModifiers.createKey("ore_tin");
    public static final ResourceKey<BiomeModifier> OIL_SAND = TFndBiomeModifiers.createKey("oil_sand");
    public static final ResourceKey<BiomeModifier> RUBBERWOOD_TREES = TFndBiomeModifiers.createKey("trees_rubberwood");

    public static void init(BootstapContext<BiomeModifier> context) {
        HolderSet.Named isBadlandsTag = context.m_255420_(Registries.f_256952_).m_254956_(BiomeTags.f_207607_);
        HolderSet.Named isOverworldTag = context.m_255420_(Registries.f_256952_).m_254956_(BiomeTags.f_215817_);
        HolderSet.Direct isBambooJungle = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(Biomes.f_48197_)});
        HolderSet.Direct isDesert = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(Biomes.f_48203_)});
        HolderSet.Direct isFlowerForest = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(Biomes.f_48179_)});
        HolderSet.Direct isSparseJungle = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(Biomes.f_186769_)});
        HolderSet oilSandsBiomes = DatapackHelper.holderSetIntersection((HolderSet[])new HolderSet[]{isOverworldTag, DatapackHelper.holderSetUnion((HolderSet[])new HolderSet[]{isDesert, isBadlandsTag})});
        HolderSet rubberwoodTreeBiomes = DatapackHelper.holderSetUnion((HolderSet[])new HolderSet[]{isFlowerForest, isBambooJungle, isSparseJungle});
        HolderSet.Direct rubberwoodTrees = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(TFndFeatures.Placed.TREES_RUBBERWOOD_PLACED)});
        TFndBiomeModifiers.registerOre(context, APATITE_ORE, (HolderSet<Biome>)isOverworldTag, TFndFeatures.Placed.APATITE_ORE);
        TFndBiomeModifiers.registerOre(context, CINNABAR_ORE, (HolderSet<Biome>)isOverworldTag, TFndFeatures.Placed.CINNABAR_ORE);
        TFndBiomeModifiers.registerOre(context, NITER_ORE, (HolderSet<Biome>)isOverworldTag, TFndFeatures.Placed.NITER_ORE);
        TFndBiomeModifiers.registerOre(context, SULFUR_ORE, (HolderSet<Biome>)isOverworldTag, TFndFeatures.Placed.SULFUR_ORE);
        TFndBiomeModifiers.registerOre(context, LEAD_ORE, (HolderSet<Biome>)isOverworldTag, TFndFeatures.Placed.LEAD_ORE);
        TFndBiomeModifiers.registerOre(context, NICKEL_ORE, (HolderSet<Biome>)isOverworldTag, TFndFeatures.Placed.NICKEL_ORE);
        TFndBiomeModifiers.registerOre(context, SILVER_ORE, (HolderSet<Biome>)isOverworldTag, TFndFeatures.Placed.SILVER_ORE);
        TFndBiomeModifiers.registerOre(context, TIN_ORE, (HolderSet<Biome>)isOverworldTag, TFndFeatures.Placed.TIN_ORE);
        TFndBiomeModifiers.registerOre(context, OIL_SAND, (HolderSet<Biome>)oilSandsBiomes, TFndFeatures.Placed.OIL_SAND);
        context.m_255272_(RUBBERWOOD_TREES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(rubberwoodTreeBiomes, (HolderSet)rubberwoodTrees, GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    private static ResourceKey<BiomeModifier> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("thermal", name));
    }

    private static void registerOre(BootstapContext<BiomeModifier> context, ResourceKey<BiomeModifier> biomeMod, HolderSet<Biome> biomes, ResourceKey<PlacedFeature> feature) {
        context.m_255272_(biomeMod, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(biomes, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(feature)}), GenerationStep.Decoration.UNDERGROUND_ORES));
    }
}

