/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api;

import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileLogger {
    private final Logger logger;
    private boolean has_errors;
    private final Path log_file;

    public FileLogger(String name) {
        this.logger = LogManager.getLogger((String)name);
        this.log_file = Paths.get("logs/" + name + ".log", new String[0]);
    }

    public void clearLog() {
        try {
            Files.write(this.log_file, (Iterable<? extends CharSequence>)Lists.newArrayList(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            this.logger.error("Failed to write to log file", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void logInfo(Object message) {
        this.writeToFile(message);
        this.logger.info(message);
    }

    public void logError(Object message, Exception e) {
        this.writeToFile(message + " " + e);
        for (StackTraceElement traceElement : e.getStackTrace()) {
            this.writeToFile(traceElement);
        }
        this.logger.error(message, (Throwable)e);
        e.printStackTrace();
        this.has_errors = true;
    }

    private boolean writeToFile(Object message) {
        return this.writeToFile(Lists.newArrayList((Object[])new String[]{String.valueOf(message)}));
    }

    private boolean writeToFile(List<String> out) {
        try {
            Files.write(this.log_file, out, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            return true;
        }
        catch (Exception e) {
            this.logger.error("Failed to write to log file", (Throwable)e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean hasErrors() {
        return this.has_errors;
    }

    public MutableComponent getFiletext() {
        String file = this.log_file.toAbsolutePath().toString();
        MutableComponent text = MutableComponent.m_237204_((ComponentContents)new LiteralContents(file));
        text.m_6270_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)MutableComponent.m_237204_((ComponentContents)new LiteralContents(file)))));
        return text;
    }

    public void clearErrors() {
        this.has_errors = false;
    }
}

