/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.config.premade.IntMinMax;
import team.creative.creativecore.common.config.premade.curve.Curve;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;
import team.creative.creativecore.common.util.type.Color;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Particle;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.client.sound.SoundMuteHandler;
import team.creative.enhancedvisuals.client.sound.TickedSound;
import team.creative.enhancedvisuals.common.event.EVEvents;
import team.creative.enhancedvisuals.common.visual.VisualRegistry;

public class VisualManager {
    private static Minecraft mc = Minecraft.m_91087_();
    public static final Random RANDOM = new Random();
    private static HashMapList<VisualCategory, Visual> visuals = new HashMapList();
    private static List<TickedSound> playing = new ArrayList<TickedSound>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onTick(@Nullable Player player) {
        boolean areEyesInWater = player != null && EVEvents.areEyesInWater(player);
        HashMapList<VisualCategory, Visual> hashMapList = visuals;
        synchronized (hashMapList) {
            Iterator iterator = visuals.iterator();
            block3: while (iterator.hasNext()) {
                Visual visual = (Visual)iterator.next();
                int factor = 1;
                if (areEyesInWater && visual.isAffectedByWater()) {
                    factor = EnhancedVisuals.CONFIG.waterSubstractFactor;
                }
                for (int i = 0; i < factor; ++i) {
                    if (visual.tick()) continue;
                    visual.removeFromDisplay();
                    iterator.remove();
                    continue block3;
                }
            }
            for (VisualHandler handler : VisualRegistry.handlers()) {
                if (!handler.isEnabled(player)) continue;
                handler.tick(player);
            }
        }
        if (player != null && !player.m_6084_()) {
            VisualManager.clearEverything();
        }
        if (!playing.isEmpty()) {
            playing.removeIf(x -> x.m_7801_());
        }
    }

    public static Collection<Visual> visuals(VisualCategory category) {
        return visuals.get((Object)category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearEverything() {
        HashMapList<VisualCategory, Visual> hashMapList = visuals;
        synchronized (hashMapList) {
            visuals.removeKey((Object)VisualCategory.particle);
        }
        if (!playing.isEmpty()) {
            for (TickedSound sound : playing) {
                sound.stop();
            }
            playing.clear();
            SoundMuteHandler.endMuting();
        }
    }

    public static void add(Visual visual) {
        if (!visual.type.disabled) {
            visual.addToDisplay();
            visuals.add((Object)visual.getCategory(), (Object)visual);
        }
    }

    public static boolean remove(Visual visual) {
        if (visuals.removeValue((Object)visual.getCategory(), (Object)visual)) {
            visual.removeFromDisplay();
            return true;
        }
        return false;
    }

    public static void playTicking(ResourceLocation location, BlockPos pos, DecimalCurve volume) {
        TickedSound sound = pos != null ? new TickedSound(location, SoundSource.MASTER, 1.0f, pos, volume) : new TickedSound(location, SoundSource.MASTER, 1.0f, volume);
        playing.add(sound);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
    }

    public static Visual addVisualFadeOut(VisualType vt, VisualHandler handler, IntMinMax time) {
        return VisualManager.addVisualFadeOut(vt, handler, (Curve)new DecimalCurve(0.0, 1.0, (double)time.next(RANDOM), 0.0));
    }

    public static Visual addVisualFadeOut(VisualType vt, VisualHandler handler, int time) {
        return VisualManager.addVisualFadeOut(vt, handler, (Curve)new DecimalCurve(0.0, 1.0, (double)time, 0.0));
    }

    public static Visual addVisualFadeOut(VisualType vt, VisualHandler handler, Curve curve) {
        Visual v = new Visual(vt, handler, curve, vt.getVariantAmount() > 1 ? RANDOM.nextInt(vt.getVariantAmount()) : 0);
        VisualManager.add(v);
        return v;
    }

    public static void addParticlesFadeOut(VisualType vt, VisualHandler handler, int count, IntMinMax time, boolean rotate) {
        VisualManager.addParticlesFadeOut(vt, handler, count, (Curve)new DecimalCurve(0.0, 1.0, (double)time.next(RANDOM), 0.0), rotate, null);
    }

    public static void addParticlesFadeOut(VisualType vt, VisualHandler handler, int count, IntMinMax time, boolean rotate, @Nullable Color color) {
        VisualManager.addParticlesFadeOut(vt, handler, count, (Curve)new DecimalCurve(0.0, 1.0, (double)time.next(RANDOM), 0.0), rotate, color);
    }

    public static void addParticlesFadeOut(VisualType vt, VisualHandler handler, int count, int time, boolean rotate) {
        VisualManager.addParticlesFadeOut(vt, handler, count, (Curve)new DecimalCurve(0.0, 1.0, (double)time, 0.0), rotate, null);
    }

    public static void addParticlesFadeOut(VisualType vt, VisualHandler handler, int count, Curve curve, boolean rotate, @Nullable Color color) {
        if (vt.disabled) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            int screenWidth = mc.m_91268_().m_85441_();
            int screenHeight = mc.m_91268_().m_85442_();
            int width = vt.getWidth(screenWidth, screenHeight);
            int height = vt.getHeight(screenWidth, screenHeight);
            if (vt.scaleVariants()) {
                double scale = vt.randomScale(RANDOM);
                width = (int)((double)width * scale);
                height = (int)((double)height * scale);
            }
            Particle particle = new Particle(vt, handler, curve, VisualManager.generateOffset(RANDOM, screenWidth, width), VisualManager.generateOffset(RANDOM, screenHeight, height), width, height, vt.canRotate() && rotate ? RANDOM.nextFloat() * 360.0f : 0.0f, RANDOM.nextInt(vt.getVariantAmount()));
            if (color != null) {
                particle.color = color;
            }
            VisualManager.add(particle);
        }
    }

    public static Particle addParticle(VisualType vt, VisualHandler handler, boolean rotate, @Nullable Color color) {
        int screenWidth = mc.m_91268_().m_85441_();
        int screenHeight = mc.m_91268_().m_85442_();
        int width = vt.getWidth(screenWidth, screenHeight);
        int height = vt.getHeight(screenWidth, screenHeight);
        if (vt.scaleVariants()) {
            double scale = vt.randomScale(RANDOM);
            width = (int)((double)width * scale);
            height = (int)((double)height * scale);
        }
        Particle particle = new Particle(vt, handler, VisualManager.generateOffset(RANDOM, screenWidth, width), VisualManager.generateOffset(RANDOM, screenHeight, height), width, height, vt.canRotate() && rotate ? RANDOM.nextFloat() * 360.0f : 0.0f, RANDOM.nextInt(vt.getVariantAmount()));
        particle.setOpacityInternal(1.0f);
        if (color != null) {
            particle.color = color;
        }
        VisualManager.add(particle);
        return particle;
    }

    public static int generateOffset(Random rand, int dimensionLength, int spacingBuffer) {
        int half = dimensionLength / 2;
        float multiplier = (float)(1.0 - Math.pow(rand.nextDouble(), 2.0));
        float textureCenterPosition = rand.nextInt(2) == 0 ? (float)half + (float)half * multiplier : (float)half - (float)half * multiplier;
        return (int)(textureCenterPosition - (float)spacingBuffer / 2.0f);
    }
}

