/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.client.EVClient;
import team.creative.enhancedvisuals.client.VisualManager;
import team.creative.enhancedvisuals.common.handler.VisualHandlers;

public class EVRenderer {
    private static ShaderInstance positionTexColorSmoothShader;
    private static Minecraft mc;
    private static String lastRenderedMessage;
    private static int framebufferWidth;
    private static int framebufferHeight;
    public static boolean reloadResources;

    public static void loadShaders(ResourceProvider provier, List<Pair<ShaderInstance, Consumer<ShaderInstance>>> shaders) throws IOException {
        shaders.add((Pair<ShaderInstance, Consumer<ShaderInstance>>)Pair.of((Object)new ShaderInstance(provier, "enhancedvisuals:position_tex_col_smooth", DefaultVertexFormat.f_85819_), x -> {
            positionTexColorSmoothShader = x;
        }));
    }

    @Nullable
    public static ShaderInstance getPositionTexColorSmoothShader() {
        return positionTexColorSmoothShader;
    }

    public static void render(Object object) {
        GuiGraphics graphics = (GuiGraphics)object;
        if (EVClient.shouldRender()) {
            if (reloadResources) {
                for (VisualType visualType : VisualType.getTypes()) {
                    visualType.loadResources(mc.m_91098_());
                }
                reloadResources = false;
            }
            if (!(EVRenderer.mc.f_91080_ instanceof DeathScreen)) {
                graphics.m_280262_();
                float partialTicks = Minecraft.m_91087_().m_91296_();
                if (EVRenderer.mc.f_91074_ != null && EVRenderer.mc.f_91074_.f_20917_ > 0 && EVRenderer.mc.f_91074_.f_20916_ == EVRenderer.mc.f_91074_.f_20917_) {
                    VisualHandlers.DAMAGE.clientHurt();
                }
                if (EVRenderer.mc.m_91385_().f_83915_ != framebufferWidth || EVRenderer.mc.m_91385_().f_83916_ != framebufferHeight) {
                    for (VisualType type : VisualType.getTypes()) {
                        type.resize(mc.m_91385_());
                    }
                    framebufferWidth = EVRenderer.mc.m_91385_().f_83915_;
                    framebufferHeight = EVRenderer.mc.m_91385_().f_83916_;
                }
                int n = mc.m_91268_().m_85441_();
                int screenHeight = mc.m_91268_().m_85442_();
                TextureManager manager = mc.m_91097_();
                RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
                Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)n, (float)screenHeight, 0.0f, 1000.0f, 21000.0f);
                RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276633_);
                PoseStack stack = RenderSystem.getModelViewStack();
                stack.m_85836_();
                stack.m_166856_();
                stack.m_85837_(0.0, 0.0, -11000.0);
                RenderSystem.applyModelViewMatrix();
                Lighting.m_84931_();
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::m_172811_);
                Matrix4f pose = new PoseStack().m_85850_().m_252922_();
                BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                int color = -16777216;
                int z = -90;
                bufferbuilder.m_252986_(pose, (float)n, (float)screenHeight, (float)z).m_193479_(color).m_5752_();
                bufferbuilder.m_252986_(pose, (float)n, 0.0f, (float)z).m_193479_(color).m_5752_();
                bufferbuilder.m_252986_(pose, 0.0f, 0.0f, (float)z).m_193479_(color).m_5752_();
                bufferbuilder.m_252986_(pose, 0.0f, (float)screenHeight, (float)z).m_193479_(color).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                RenderSystem.disableBlend();
                RenderSystem.resetTextureMatrix();
                RenderSystem.disableDepthTest();
                EVRenderer.renderVisuals(stack, VisualManager.visuals(VisualCategory.shader), manager, n, screenHeight, partialTicks);
                mc.m_91385_().m_83947_(true);
                RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
                RenderSystem.enableBlend();
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                EVRenderer.renderVisuals(stack, VisualManager.visuals(VisualCategory.overlay), manager, n, screenHeight, partialTicks);
                EVRenderer.renderVisuals(stack, VisualManager.visuals(VisualCategory.particle), manager, n, screenHeight, partialTicks);
                RenderSystem.applyModelViewMatrix();
                lastRenderedMessage = null;
                graphics.m_280262_();
                Window window = mc.m_91268_();
                RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
                RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)((double)window.m_85441_() / window.m_85449_()), (float)((double)window.m_85442_() / window.m_85449_()), 0.0f, 1000.0f, 21000.0f), (VertexSorting)VertexSorting.f_276633_);
                stack.m_85849_();
                RenderSystem.applyModelViewMatrix();
                Lighting.m_84931_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.depthMask((boolean)true);
            } else if (EnhancedVisuals.MESSAGES.enabled) {
                if (lastRenderedMessage == null) {
                    lastRenderedMessage = EnhancedVisuals.MESSAGES.pickRandomDeathMessage();
                }
                if (lastRenderedMessage != null) {
                    graphics.m_280488_(EVRenderer.mc.f_91062_, "\"" + lastRenderedMessage + "\"", EVRenderer.mc.f_91080_.f_96543_ / 2 - EVRenderer.mc.f_91062_.m_92895_(lastRenderedMessage) / 2, 114, 0xFFFFFF);
                }
            }
        }
    }

    private static void renderVisuals(PoseStack stack, Collection<Visual> visuals, TextureManager manager, int screenWidth, int screenHeight, float partialTicks) {
        if (visuals == null || visuals.isEmpty()) {
            return;
        }
        try {
            for (Visual visual : visuals) {
                if (!visual.isVisible()) continue;
                visual.render(stack, manager, screenWidth, screenHeight, partialTicks);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        mc = Minecraft.m_91087_();
        reloadResources = false;
    }
}

