/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.handler;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.event.SelectEndermanEvent;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeOverlay;
import team.creative.enhancedvisuals.client.VisualManager;

public class SlenderHandler
extends VisualHandler {
    @CreativeConfig
    public double defaultIntensity = 0.0;
    @CreativeConfig
    public double maxIntensity = 0.3;
    @CreativeConfig
    public double distanceFactor = 0.25;
    @CreativeConfig
    public VisualType slender = new VisualTypeOverlay("slender", 50);
    public Visual slenderVisual;
    public Class mutantEnderman = this.loadMutantEnderman();

    private Class loadMutantEnderman() {
        try {
            return Class.forName("chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void tick(@Nullable Player player) {
        if (this.slenderVisual == null) {
            this.slenderVisual = new Visual(this.slender, this, 0);
            VisualManager.add(this.slenderVisual);
        }
        float intensity = (float)this.defaultIntensity;
        if (player != null) {
            float modifier = 0.0f;
            double d0 = player.m_20185_();
            double d1 = player.m_20186_();
            double d2 = player.m_20189_();
            AABB box = player.m_20191_();
            box = box.m_82377_(16.0, 16.0, 16.0);
            SelectEndermanEvent event = new SelectEndermanEvent(TargetingConditions.m_148353_());
            CreativeCore.loader().postForge((Event)event);
            if (!event.isCanceled()) {
                LivingEntity mob = player.m_9236_().m_45963_(EnderMan.class, event.conditions, (LivingEntity)player, d0, d1, d2, box);
                if (this.mutantEnderman != null) {
                    mob = player.m_9236_().m_45963_(this.mutantEnderman, TargetingConditions.m_148353_(), (LivingEntity)player, d0, d1, d2, box);
                }
                if (mob != null) {
                    float distModifier = (float)(1.0 / Math.pow(Math.sqrt(Math.pow(d0 - mob.m_20185_(), 2.0) + Math.pow(d1 - mob.m_20186_(), 2.0) + Math.pow(d2 - mob.m_20189_(), 2.0)) / 3.0, 2.0));
                    if (distModifier > modifier && (modifier = distModifier) > 3.5f) {
                        modifier = 3.5f;
                    }
                    intensity = (float)Math.max(this.defaultIntensity, Math.min(this.maxIntensity, this.distanceFactor * (double)modifier));
                }
            }
        }
        this.slenderVisual.setOpacityInternal(intensity);
    }
}

