/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests;

import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.colossalchests.Advancements;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ChestWallConfig;
import org.cyclops.colossalchests.block.ColossalChestConfig;
import org.cyclops.colossalchests.block.InterfaceConfig;
import org.cyclops.colossalchests.block.UncolossalChestConfig;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChestConfig;
import org.cyclops.colossalchests.blockentity.BlockEntityInterfaceConfig;
import org.cyclops.colossalchests.blockentity.BlockEntityUncolossalChestConfig;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChestConfig;
import org.cyclops.colossalchests.inventory.container.ContainerUncolossalChestConfig;
import org.cyclops.colossalchests.item.ItemUpgradeToolConfig;
import org.cyclops.colossalchests.modcompat.CommonCapabilitiesModCompat;
import org.cyclops.colossalchests.modcompat.IronChestModCompat;
import org.cyclops.colossalchests.proxy.ClientProxy;
import org.cyclops.colossalchests.proxy.CommonProxy;
import org.cyclops.colossalchests.recipe.condition.RecipeConditionMetalVariantsSettingConfig;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.ModBaseVersionable;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;

@Mod(value="colossalchests")
public class ColossalChests
extends ModBaseVersionable<ColossalChests> {
    public static ColossalChests _instance;

    public ColossalChests() {
        super("colossalchests", instance -> {
            _instance = instance;
        });
    }

    protected void loadModCompats(ModCompatLoader modCompatLoader) {
        modCompatLoader.addModCompat((IModCompat)new IronChestModCompat());
        modCompatLoader.addModCompat((IModCompat)new CommonCapabilitiesModCompat());
    }

    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
        Advancements.load();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return super.constructDefaultCreativeModeTab(builder).m_257737_(() -> new ItemStack((ItemLike)RegistryEntries.ITEM_CHEST));
    }

    protected void onConfigsRegister(ConfigHandler configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfig)new GeneralConfig());
        for (ChestMaterial material : ChestMaterial.VALUES) {
            configHandler.addConfigurable((ExtendedConfig)new ChestWallConfig(material));
            configHandler.addConfigurable((ExtendedConfig)new ColossalChestConfig(material));
            configHandler.addConfigurable((ExtendedConfig)new InterfaceConfig(material));
        }
        configHandler.addConfigurable((ExtendedConfig)new UncolossalChestConfig());
        configHandler.addConfigurable((ExtendedConfig)new ItemUpgradeToolConfig(true));
        configHandler.addConfigurable((ExtendedConfig)new ItemUpgradeToolConfig(false));
        configHandler.addConfigurable((ExtendedConfig)new BlockEntityColossalChestConfig());
        configHandler.addConfigurable((ExtendedConfig)new BlockEntityInterfaceConfig());
        configHandler.addConfigurable((ExtendedConfig)new BlockEntityUncolossalChestConfig());
        configHandler.addConfigurable((ExtendedConfig)new ContainerColossalChestConfig());
        configHandler.addConfigurable((ExtendedConfig)new ContainerUncolossalChestConfig());
        configHandler.addConfigurable((ExtendedConfig)new RecipeConditionMetalVariantsSettingConfig());
    }

    public static void clog(String message) {
        ColossalChests.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }
}

