/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.world.gen;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import owmii.powah.Powah;
import owmii.powah.block.Blcks;
import owmii.powah.config.v2.PowahConfig;

public class Features {
    public static final ResourceKey<PlacedFeature> PLACED_DRY_ICE = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)Powah.id("dry_ice"));
    public static final ResourceKey<PlacedFeature> PLACED_URANINITE_POOR = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)Powah.id("uraninite_ore_poor"));
    public static final ResourceKey<PlacedFeature> PLACED_URANINITE = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)Powah.id("uraninite_ore"));
    public static final ResourceKey<PlacedFeature> PLACED_URANINITE_DENSE = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)Powah.id("uraninite_ore_dense"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> DRY_ICE = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)Powah.id("dry_ice"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> URANINITE_POOR = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)Powah.id("uraninite_ore_poor"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> URANINITE = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)Powah.id("uraninite_ore"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> URANINITE_DENSE = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)Powah.id("uraninite_ore_dense"));

    public static void initConfiguredFeatures(BootstapContext<ConfiguredFeature<?, ?>> bootstrap) {
        Features.registerConfiguredFeature(bootstrap, DRY_ICE, Blcks.DRY_ICE, Blcks.DRY_ICE, 17);
        Features.registerConfiguredFeature(bootstrap, URANINITE_POOR, Blcks.URANINITE_ORE_POOR, Blcks.DEEPSLATE_URANINITE_ORE_POOR, 5);
        Features.registerConfiguredFeature(bootstrap, URANINITE, Blcks.URANINITE_ORE, Blcks.DEEPSLATE_URANINITE_ORE, 4);
        Features.registerConfiguredFeature(bootstrap, URANINITE_DENSE, Blcks.URANINITE_ORE_DENSE, Blcks.DEEPSLATE_URANINITE_ORE_DENSE, 3);
    }

    public static void initPlacedFeatures(BootstapContext<PlacedFeature> bootstrap) {
        Features.registerPlacedFeature(bootstrap, PLACED_DRY_ICE, DRY_ICE, wg -> wg.dry_ice_veins_per_chunk, 64);
        Features.registerPlacedFeature(bootstrap, PLACED_URANINITE_POOR, URANINITE_POOR, wg -> wg.poor_uraninite_veins_per_chunk, 64);
        Features.registerPlacedFeature(bootstrap, PLACED_URANINITE, URANINITE, wg -> wg.uraninite_veins_per_chunk, 20);
        Features.registerPlacedFeature(bootstrap, PLACED_URANINITE_DENSE, URANINITE_DENSE, wg -> wg.dense_uraninite_veins_per_chunk, 0);
    }

    private static void registerConfiguredFeature(BootstapContext<ConfiguredFeature<?, ?>> bootstrap, ResourceKey<ConfiguredFeature<?, ?>> key, Supplier<Block> block, Supplier<Block> deepslateBlock, int amountPerVein) {
        List<OreConfiguration.TargetBlockState> target = List.of(OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_144266_), (BlockState)block.get().m_49966_()), OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_144267_), (BlockState)deepslateBlock.get().m_49966_()));
        ConfiguredFeature conf = new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(target, amountPerVein));
        bootstrap.m_255272_(key, (Object)conf);
    }

    private static void registerPlacedFeature(BootstapContext<PlacedFeature> bootstrap, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> configuredId, Function<PowahConfig.WorldGen, Integer> veinsPerChunk, int maxY) {
        Holder.Reference configuredFeature = (Holder.Reference)bootstrap.m_255420_(Registries.f_256911_).m_254902_(configuredId).orElseThrow();
        PlacedFeature placed = new PlacedFeature((Holder)configuredFeature, OrePlacements.m_195343_((int)veinsPerChunk.apply(Powah.config().worldgen), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY))));
        bootstrap.m_255272_(key, (Object)placed);
    }
}

