/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.mobsunscreen.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Boolean> printIDs;
        public final ForgeConfigSpec.ConfigValue<Boolean> protectAllMobs;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> mods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> mobs;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.printIDs = builder.comment("Print all found mob IDS to the console, will cause spam").define("printIDs", false);
            this.protectAllMobs = builder.comment("Protects all mobs from fire").define("protectAllMobs", false);
            this.mods = builder.comment("Protects these mods from fire (any mobs with these namespaces)").defineListAllowEmpty(List.of("mods"), () -> List.of("iceandfire"), o -> o instanceof String);
            this.mobs = builder.comment("Protects these mobs from fire (any mobs with these ids (namespace:name))").defineListAllowEmpty(List.of("mobs"), () -> List.of("minecraft:zombie", "minecraft:drowned", "minecraft:skeleton", "minecraft:stray"), o -> o instanceof String);
        }
    }
}

