/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.blocks.tileentity;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.foxmcloud.draconicadditions.blocks.tileentity.TileChaosHolderBase;
import net.foxmcloud.draconicadditions.inventory.ChaosInfuserMenu;
import net.foxmcloud.draconicadditions.lib.DAContent;
import net.foxmcloud.draconicadditions.modules.DAModuleTypes;
import net.foxmcloud.draconicadditions.modules.data.StableChaosData;
import net.foxmcloud.draconicadditions.modules.entities.StableChaosEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class TileChaosInfuser
extends TileChaosHolderBase
implements IChangeListener,
IInteractTile,
MenuProvider {
    private int chargeRate = 20000;
    private int rateMultiplier = 2;
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", false, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));

    public TileChaosInfuser(BlockPos pos, BlockState state) {
        super((BlockEntityType)DAContent.tileChaosInfuser.get(), pos, state);
        this.itemHandler = new TileItemStackHandler((BlockEntity)this, 2);
        this.opStorage = new ModularOPStorage((TileBCore)this, 10000000L, 100000L, 100000L);
        this.capManager.setManaged("energy", CapabilityOP.OP, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.capManager.setInternalManaged("inventory", ForgeCapabilities.ITEM_HANDLER, (INBTSerializable)this.itemHandler).saveBoth().syncTile();
        this.itemHandler.setStackValidator(this::isItemValidForSlot);
        this.setupPowerSlot((IItemHandler)this.itemHandler, 1, (IOPStorage)this.opStorage, false);
        this.installIOTracker(this.opStorage);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.m_5776_()) {
            if (this.active.get()) {
                float beamPitch = (float)(0.5 + Math.random() * (double)0.1f);
                this.f_58857_.m_7785_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5, (SoundEvent)DESounds.BEAM.get(), SoundSource.BLOCKS, 0.2f, beamPitch, false);
            }
        } else {
            ItemStack stack = this.itemHandler.getStackInSlot(0);
            int opToTake = this.chargeRate * this.rateMultiplier;
            if (this.isTileEnabled() && !stack.m_41619_() && this.isItemValidForSlot(0, stack) && this.chaos.get() > 0 && this.opStorage.extractOP((long)opToTake, true) >= (long)this.chargeRate) {
                ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElse(null);
                if (host == null) {
                    opToTake = this.chargeRate * stack.m_41613_();
                    if (this.chaos.get() >= 20000 * stack.m_41613_() && this.opStorage.extractOP((long)opToTake, true) >= (long)opToTake) {
                        this.chaos.subtract(20000 * stack.m_41613_());
                        this.opStorage.extractOP((long)opToTake, false);
                        ItemStack heart = ((Item)DAContent.chaosHeart.get()).m_7968_();
                        heart.m_41764_(stack.m_41613_());
                        this.itemHandler.setStackInSlot(0, heart);
                    }
                    this.active.set(false);
                    return;
                }
                Stream chaosEntities = host.getEntitiesByType(DAModuleTypes.STABLE_CHAOS);
                ArrayList<StableChaosEntity> sortedChaosEntities = StableChaosEntity.getSortedListFromStream(chaosEntities);
                if (sortedChaosEntities.size() == 0) {
                    this.active.set(false);
                    return;
                }
                int remainingChaosToTransfer = Math.min(this.rateMultiplier, this.chaos.get());
                for (StableChaosEntity ce : sortedChaosEntities) {
                    long opRemoved;
                    int chaosAdded;
                    StableChaosData data = (StableChaosData)ce.getModule().getData();
                    if (ce.getChaos() >= data.getMaxChaos()) continue;
                    this.active.set(true);
                    if ((remainingChaosToTransfer -= (chaosAdded = ce.modifyChaos((int)((opRemoved = this.opStorage.extractOP((long)(this.chargeRate * remainingChaosToTransfer), false)) / (long)this.chargeRate)))) != 0) continue;
                    break;
                }
                this.chaos.subtract(Math.min(this.rateMultiplier, this.chaos.get()) - remainingChaosToTransfer);
                if (remainingChaosToTransfer == this.rateMultiplier) {
                    this.active.set(false);
                }
            } else {
                this.active.set(false);
            }
        }
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (index == 1) {
            return EnergyUtils.isEnergyItem((ItemStack)stack);
        }
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElse(null);
        if (host != null) {
            StableChaosData data = (StableChaosData)host.getModuleData(DAModuleTypes.STABLE_CHAOS);
            return data != null ? data.getMaxChaos() > 0 : false;
        }
        return stack.m_41720_() == DEContent.DRAGON_HEART.get();
    }

    public AbstractContainerMenu m_7208_(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new ChaosInfuserMenu(currentWindowIndex, player.m_150109_(), this);
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        }
        return true;
    }
}

