/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.datagen;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.foxmcloud.draconicadditions.datagen.BlockLootProvider;
import net.foxmcloud.draconicadditions.datagen.BlockStateGenerator;
import net.foxmcloud.draconicadditions.datagen.BlockTagGenerator;
import net.foxmcloud.draconicadditions.datagen.ItemModelGenerator;
import net.foxmcloud.draconicadditions.datagen.LangGenerator;
import net.foxmcloud.draconicadditions.datagen.RecipeGenerator;
import net.foxmcloud.draconicadditions.integration.DACuriosIntegration;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenEventHandler {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            gen.addProvider(true, (DataProvider)new LangGenerator(gen.getPackOutput()));
            gen.addProvider(true, (DataProvider)new BlockStateGenerator(gen, event.getExistingFileHelper()));
            gen.addProvider(true, (DataProvider)new ItemModelGenerator(gen, event.getExistingFileHelper()));
        }
        if (event.includeServer()) {
            gen.addProvider(true, (DataProvider)new RecipeGenerator(gen.getPackOutput()));
            gen.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(event.getGenerator().getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLootProvider::new, LootContextParamSets.f_81421_))));
            BlockTagGenerator blockGenerator = new BlockTagGenerator(gen.getPackOutput(), event.getLookupProvider(), "draconicadditions", event.getExistingFileHelper());
            gen.addProvider(true, (DataProvider)blockGenerator);
            gen.addProvider(true, (DataProvider)new ItemTagGenerator(gen.getPackOutput(), event.getLookupProvider(), blockGenerator.m_274426_(), "draconicadditions", event.getExistingFileHelper()));
        }
    }

    private static class ItemTagGenerator
    extends ItemTagsProvider {
        public ItemTagGenerator(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pLookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> pBlockTags, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(pOutput, pLookupProvider, pBlockTags, modId, existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider pProvider) {
            if (ModList.get().isLoaded("curios")) {
                DACuriosIntegration.generateTags(x$0 -> this.m_206424_((TagKey)x$0));
            }
        }
    }
}

