/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.items.tools;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.IInvCharge;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.data.ShieldData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEDamage;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.TechProperties;
import java.util.List;
import javax.annotation.Nullable;
import net.foxmcloud.draconicadditions.CommonMethods;
import net.foxmcloud.draconicadditions.DAConfig;
import net.foxmcloud.draconicadditions.blocks.tileentity.TileChaosHolderBase;
import net.foxmcloud.draconicadditions.items.IChaosContainer;
import net.foxmcloud.draconicadditions.items.IModularEnergyItem;
import net.foxmcloud.draconicadditions.items.ISimpleCountdown;
import net.foxmcloud.draconicadditions.modules.entities.ChaosInjectorEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class ChaosContainer
extends Item
implements IModularEnergyItem,
IChaosContainer,
IInvCharge,
ISimpleCountdown {
    private TechLevel techLevel;

    public ChaosContainer(TechProperties props) {
        super((Item.Properties)props);
        this.techLevel = props.getTechLevel();
    }

    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = IModularEnergyItem.super.createHost(stack);
        host.addAdditionalType(ModuleTypes.SHIELD_BOOST);
        return host;
    }

    public void upkeep(Player player, ItemStack stack, Level world) {
        if (this.getChaos(stack) > 0 && !player.m_7500_() && !player.m_5833_()) {
            long RFToDrain;
            if (CommonMethods.cheatCheck(stack, world) || !this.hasShielding(stack)) {
                this.extractEnergy(player, stack, Long.MAX_VALUE);
            }
            if (this.extractEnergy(player, stack, RFToDrain = this.getRFCost(stack)) < RFToDrain) {
                Vector3 pos = new Vector3(player.m_20185_(), player.m_20186_(), player.m_20189_());
                CommonMethods.explodeEntity(pos, world);
                player.m_6469_(DEDamage.chaosImplosion((Level)world), (float)this.getChaos(stack));
                player.m_5661_((Component)Component.m_237110_((String)"info.da.chaos.explode", (Object[])new Object[]{this.m_7626_(stack).getString()}), true);
                stack.m_41774_(1);
            } else if (this.shouldAlarm(stack) && this.hasShielding(stack)) {
                if (this.getCurrentCountdown(stack) <= 0 || this.getCountdownAmount(stack) <= this.getCurrentCountdown(stack)) {
                    this.resetCountdown(stack);
                }
                if (this.advanceCountdown(stack)) {
                    player.m_5661_((Component)Component.m_237110_((String)"info.da.chaos.warning", (Object[])new Object[]{this.m_7626_(stack)}).m_130940_(ChatFormatting.RED), true);
                } else if (this.getCurrentCountdown(stack) == this.getCountdownAmount(stack) / 2) {
                    player.m_5661_((Component)Component.m_237113_((String)""), true);
                }
            }
        } else {
            CommonMethods.cheatCheck(stack, world);
        }
    }

    public void handleTick(ItemStack stack, LivingEntity entity, @Nullable EquipmentSlot slot, boolean inEquipModSlot) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_9236_().f_46443_ && this.shouldAlarm(stack) && this.hasShielding(stack) && !player.m_7500_() && !player.m_5833_() && this.getCurrentCountdown(stack) <= 0) {
            float pitch = 1.5f + (float)(1.0 - (double)EnergyUtils.getEnergyStored((ItemStack)stack) / (double)EnergyUtils.getMaxEnergyStored((ItemStack)stack)) * 0.5f;
            player.m_9236_().m_5594_(player, player.m_20183_(), (SoundEvent)DESounds.BEAM.get(), SoundSource.MASTER, 1.0f, pitch);
        }
        this.upkeep(player, stack, player.m_9236_());
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        if (this.getChaos(stack) > 0 && !player.m_7500_()) {
            player.m_5661_((Component)Component.m_237110_((String)"info.da.chaos.cantdrop", (Object[])new Object[]{stack.m_41786_()}), true);
            return false;
        }
        ItemNBTHelper.setLong((ItemStack)stack, (String)"cheatCheck", (long)0L);
        return true;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity ent = (LivingEntity)entity;
            return this.m_6880_(stack, player, ent, InteractionHand.MAIN_HAND).m_19077_();
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        if (world.m_7702_(pos) instanceof TileChaosHolderBase) {
            TileChaosHolderBase tileEntity = (TileChaosHolderBase)world.m_7702_(pos);
            if (((ChaosContainer)stack.m_41720_()).getChaos(stack) > 0 && tileEntity.chaos.get() != tileEntity.getMaxChaos()) {
                int chaosToRemove = Math.min(tileEntity.getMaxChaos() - tileEntity.chaos.get(), this.getChaos(stack));
                int removed = this.removeChaos(stack, chaosToRemove);
                player.m_5661_((Component)Component.m_237110_((String)"info.da.chaos.xfer.to", (Object[])new Object[]{removed, tileEntity.m_7755_()}), true);
                tileEntity.chaos.add(removed);
            } else {
                int chaosToAdd = Math.min(this.getMaxChaos(stack) - this.getChaos(stack), tileEntity.chaos.get());
                int added = chaosToAdd - this.addChaos(stack, chaosToAdd);
                player.m_5661_((Component)Component.m_237110_((String)"info.da.chaos.xfer.from", (Object[])new Object[]{added, tileEntity.m_7755_()}), true);
                tileEntity.chaos.subtract(added);
            }
            return InteractionResult.SUCCESS;
        }
        return this.handleChaosInBlood(player, stack).m_19089_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return this.handleChaosInBlood(player, player.m_21120_(hand));
    }

    private InteractionResultHolder<ItemStack> handleChaosInBlood(Player player, ItemStack stack) {
        ChaosInjectorEntity injector = ChaosInjectorEntity.getInjectorEntity((LivingEntity)player);
        if (injector != null && injector.isChaosInBlood()) {
            this.removeChaos(stack, injector.modifyChaos(-1));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.getChaos(oldStack) != this.getChaos(newStack);
    }

    public boolean canCharge(ItemStack stack, LivingEntity player, boolean isHeld) {
        return true;
    }

    @Override
    public int getMaxChaos(ItemStack stack) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElse((Object)new ModuleHostImpl(TechLevel.CHAOTIC, 4, 4, "curios", false, new ModuleCategory[]{CHAOS_CONTAINER}));
        return ((ShieldData)host.getModuleData(ModuleTypes.SHIELD_BOOST, (ModuleData)new ShieldData(0, 0.0))).shieldCapacity() * 50;
    }

    private double getRFCostPerChaos(ShieldData shielding) {
        return (double)(shielding.shieldCapacity() / 2 * (shielding.shieldCapacity() / 2)) * EquipCfg.shieldPassiveModifier / shielding.shieldRecharge() * DAConfig.chaosContainerRFMultiplier;
    }

    private long getRFCost(ItemStack stack) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        ShieldData shielding = (ShieldData)host.getModuleData(ModuleTypes.SHIELD_BOOST, (ModuleData)new ShieldData(0, 0.0));
        return Math.round(this.getRFCostPerChaos(shielding) * (double)this.getChaos(stack) * (this.getChaos(stack) > this.getMaxChaos(stack) && this.hasShielding(stack) ? Math.pow(2.0, (double)this.getChaos(stack) / (double)this.getMaxChaos(stack)) : 1.0));
    }

    private boolean shouldAlarm(ItemStack stack) {
        return this.getChaos(stack) > 0 && (this.getChaos(stack) > this.getMaxChaos(stack) || this.getEnergyStored(stack) < EnergyUtils.getMaxEnergyStored((ItemStack)stack) / 2L);
    }

    private boolean hasShielding(ItemStack stack) {
        return this.getMaxChaos(stack) > 0;
    }

    @Override
    public int getCountdownAmount(ItemStack stack) {
        return Math.max((int)Math.round((double)EnergyUtils.getEnergyStored((ItemStack)stack) / (double)EnergyUtils.getMaxEnergyStored((ItemStack)stack) * 40.0), 2);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flags) {
        boolean hasEnergy;
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"[Modular Item]").m_130940_(ChatFormatting.BLUE));
        }
        tooltip.add(this.getChaosInfo(stack));
        EnergyUtils.addEnergyInfo((ItemStack)stack, tooltip);
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElse(null);
        if (host != null) {
            long rfCost = this.getRFCost(stack);
            if (rfCost >= 0L) {
                tooltip.add((Component)Component.m_237110_((String)"info.da.opCost", (Object[])new Object[]{Utils.formatNumber((long)rfCost)}).m_130940_(ChatFormatting.GRAY));
            }
            if (this.shouldAlarm(stack) && this.hasShielding(stack)) {
                tooltip.add((Component)(this.getCurrentCountdown(stack) > this.getCountdownAmount(stack) / 2 ? Component.m_237110_((String)"info.da.chaos.warning", (Object[])new Object[]{this.m_7626_(stack)}).m_130940_(ChatFormatting.RED) : Component.m_237113_((String)"")));
            }
        }
        boolean bl = hasEnergy = EnergyUtils.getMaxEnergyStored((ItemStack)stack) > 0L;
        if (!hasEnergy || !this.hasShielding(stack)) {
            if (!this.hasShielding(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"info.da.chaos.noShield").m_130940_(ChatFormatting.RED));
            }
            if (!hasEnergy) {
                tooltip.add((Component)Component.m_237115_((String)"modular_item.draconicevolution.requires_energy").m_130940_(ChatFormatting.RED));
            }
            if (KeyBindings.toolModules != null && KeyBindings.toolModules.m_90863_() != null) {
                tooltip.add((Component)Component.m_237110_((String)"modular_item.draconicevolution.requires_energy_press", (Object[])new Object[]{KeyBindings.toolModules.m_90863_().getString()}).m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    public boolean isEquipped(ItemStack stack, EquipmentSlot slot, boolean inEquipmentSlot) {
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int m_142158_(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return this.damageBarColour(stack);
    }
}

