/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.lib;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AutoFeedData;
import com.brandon3055.draconicevolution.api.modules.items.ModuleItem;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleImpl;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import java.util.function.Function;
import net.foxmcloud.draconicadditions.DAConfig;
import net.foxmcloud.draconicadditions.modules.DAModuleTypes;
import net.foxmcloud.draconicadditions.modules.data.ChaosInjectorData;
import net.foxmcloud.draconicadditions.modules.data.StableChaosData;
import net.foxmcloud.draconicadditions.modules.data.TickAccelData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class DAModules {
    public static final DeferredRegister<Module<?>> MODULES = DeferredRegister.create((ResourceKey)DEModules.MODULE_KEY, (String)"draconicadditions");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"draconicadditions");
    public static final RegistryObject<Module<?>> chaoticAutoFeed = MODULES.register("chaotic_auto_feed", () -> new ModuleImpl(ModuleTypes.AUTO_FEED, TechLevel.CHAOTIC, DAModules.autoFeedData((float)DAConfig.chaoticFeedAmount)));
    public static final RegistryObject<Module<?>> draconicTickAccel = MODULES.register("draconic_tick_accel", () -> new ModuleImpl(DAModuleTypes.TICK_ACCEL, TechLevel.DRACONIC, DAModules.tickAccelData(DAConfig.draconicAccelTicks)));
    public static final RegistryObject<Module<?>> chaoticTickAccel = MODULES.register("chaotic_tick_accel", () -> new ModuleImpl(DAModuleTypes.TICK_ACCEL, TechLevel.CHAOTIC, DAModules.tickAccelData(DAConfig.chaoticAccelTicks)));
    public static final RegistryObject<Module<?>> semiStableChaos = MODULES.register("semi_stable_chaos", () -> new ModuleImpl(DAModuleTypes.STABLE_CHAOS, TechLevel.CHAOTIC, DAModules.stableChaosData(DAConfig.semiStableInstabilityMax, DAConfig.semiStableChaosMax)));
    public static final RegistryObject<Module<?>> stableChaos = MODULES.register("stable_chaos", () -> new ModuleImpl(DAModuleTypes.STABLE_CHAOS, TechLevel.CHAOTIC, DAModules.stableChaosData(DAConfig.stableInstabilityMax, DAConfig.stableChaosMax)));
    public static final RegistryObject<Module<?>> unstableChaos = MODULES.register("unstable_chaos", () -> new ModuleImpl(DAModuleTypes.STABLE_CHAOS, TechLevel.CHAOTIC, DAModules.stableChaosData(DAConfig.unstableInstabilityMax, DAConfig.unstableChaosMax)));
    public static final RegistryObject<Module<?>> chaosInjector = MODULES.register("chaos_injector", () -> new ModuleImpl(DAModuleTypes.CHAOS_INJECTOR, TechLevel.CHAOTIC, DAModules.chaosInjectorData(DAConfig.chaosInjectorRate)));
    public static final RegistryObject<ModuleItem<?>> itemChaoticAutoFeed = ITEMS.register("item_chaotic_auto_feed", () -> new ModuleItem(chaoticAutoFeed));
    public static final RegistryObject<ModuleItem<?>> itemDraconicTickAccel = ITEMS.register("item_draconic_tick_accel", () -> new ModuleItem(draconicTickAccel));
    public static final RegistryObject<ModuleItem<?>> itemChaoticTickAccel = ITEMS.register("item_chaotic_tick_accel", () -> new ModuleItem(chaoticTickAccel));
    public static final RegistryObject<ModuleItem<?>> itemSemiStableChaos = ITEMS.register("item_semi_stable_chaos", () -> new ModuleItem(semiStableChaos));
    public static final RegistryObject<ModuleItem<?>> itemStableChaos = ITEMS.register("item_stable_chaos", () -> new ModuleItem(stableChaos));
    public static final RegistryObject<ModuleItem<?>> itemUnstableChaos = ITEMS.register("item_unstable_chaos", () -> new ModuleItem(unstableChaos));
    public static final RegistryObject<ModuleItem<?>> itemChaosInjector = ITEMS.register("item_chaos_injector", () -> new ModuleItem(chaosInjector));

    public static void init() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MODULES.register(eventBus);
        ITEMS.register(eventBus);
    }

    private static Function<Module<AutoFeedData>, AutoFeedData> autoFeedData(float defFoodStorage) {
        return e -> {
            float foodStorage = (float)ModuleCfg.getModuleDouble((Module)e, (String)"food_storage", (double)defFoodStorage);
            return new AutoFeedData((double)foodStorage);
        };
    }

    private static Function<Module<TickAccelData>, TickAccelData> tickAccelData(int defTickSpeed) {
        return e -> new TickAccelData(ModuleCfg.getModuleInt((Module)e, (String)"tick_accel", (int)defTickSpeed));
    }

    private static Function<Module<StableChaosData>, StableChaosData> stableChaosData(int maxInstability, int defMaxChaos) {
        return e -> new StableChaosData(ModuleCfg.getModuleInt((Module)e, (String)"max_instability", (int)maxInstability), ModuleCfg.getModuleInt((Module)e, (String)"max_chaos", (int)defMaxChaos));
    }

    private static Function<Module<ChaosInjectorData>, ChaosInjectorData> chaosInjectorData(int defRate) {
        return e -> new ChaosInjectorData(ModuleCfg.getModuleInt((Module)e, (String)"injection_rate", (int)defRate));
    }
}

