/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.modules.entities;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.data.ProjectileData;
import com.brandon3055.draconicevolution.api.modules.lib.EntityOverridesItemUse;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.foxmcloud.draconicadditions.entity.EntityBombProjectile;
import net.foxmcloud.draconicadditions.modules.data.BombProjectileData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import org.jetbrains.annotations.NotNull;

public class BombProjectileEntity
extends ModuleEntity<BombProjectileData>
implements EntityOverridesItemUse,
Comparable {
    private static final long costPerRadius = 1000L;
    private static final int chargePerTick = 5;
    private int charge = 0;
    private IntegerProperty radius;

    public BombProjectileEntity(Module<BombProjectileData> module) {
        super(module);
        this.radius = new IntegerProperty("bomb_projectile.radius", 1).setFormatter(ConfigProperty.IntegerFormatter.AOE).range(0, ((BombProjectileData)module.getData()).getRadius());
        this.addProperty((ConfigProperty)this.radius);
        this.savePropertiesToItem = true;
    }

    public long getRFCost() {
        int blockRadius = this.radius.getValue() * 2 + 1;
        return (long)(blockRadius * blockRadius) * 1000L;
    }

    public void onEntityUseItem(LivingEntityUseItemEvent useEvent) {
        if (useEvent.isCanceled()) {
            return;
        }
        if (useEvent instanceof LivingEntityUseItemEvent.Start) {
            LivingEntityUseItemEvent.Start event = (LivingEntityUseItemEvent.Start)useEvent;
            event.setDuration(72000);
        } else if (useEvent instanceof LivingEntityUseItemEvent.Tick) {
            LivingEntityUseItemEvent.Tick event = (LivingEntityUseItemEvent.Tick)useEvent;
            this.useTick(event);
        } else if (useEvent instanceof LivingEntityUseItemEvent.Stop || useEvent instanceof LivingEntityUseItemEvent.Finish) {
            this.endUse(useEvent);
        }
    }

    private void useTick(LivingEntityUseItemEvent.Tick event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ItemStack stack = event.getItem();
        LazyOptional optional = stack.getCapability(DECapabilities.OP_STORAGE);
        if (!optional.isPresent()) {
            return;
        }
        IOPStorage storage = (IOPStorage)optional.orElseThrow(IllegalStateException::new);
        if (this.charge < 100 && storage.extractOP(this.getRFCost(), true) >= this.getRFCost()) {
            storage.extractOP(this.getRFCost(), false);
            this.charge += 5;
            if (this.charge > 100) {
                this.charge = 100;
            }
        }
    }

    private void endUse(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            ItemStack stack = event.getItem();
            if (this.charge < 0) {
                this.charge = 0;
                return;
            }
            ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
            ProjectileData projData = (ProjectileData)host.getModuleData(ModuleTypes.PROJ_MODIFIER, (ModuleData)new ProjectileData(0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
            float velocity = (float)this.charge / 100.0f * (projData.velocity() + 1.0f);
            double xAng = player.m_20154_().f_82479_;
            double yAng = player.m_20154_().f_82480_;
            double zAng = player.m_20154_().f_82481_;
            EntityBombProjectile projectile = new EntityBombProjectile((EntityType<? extends AbstractHurtingProjectile>)EntityType.f_20463_, (LivingEntity)player, xAng, yAng, zAng, player.m_9236_());
            projectile.f_36813_ = (double)velocity * xAng;
            projectile.f_36814_ = (double)velocity * yAng;
            projectile.f_36815_ = (double)velocity * zAng;
        }
    }

    public void writeToItemStack(ItemStack stack, ModuleContext context) {
        super.writeToItemStack(stack, context);
        stack.m_41784_().m_128405_("charge", this.charge);
    }

    public void readFromItemStack(ItemStack stack, ModuleContext context) {
        super.readFromItemStack(stack, context);
        if (stack.m_41782_()) {
            this.charge = stack.m_41784_().m_128451_("charge");
        }
    }

    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128405_("charge", this.charge);
    }

    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.charge = compound.m_128451_("charge");
    }

    public void addToolTip(List<Component> tooltip) {
        BombProjectileData data = (BombProjectileData)this.module.getData();
        tooltip.add((Component)Component.m_237110_((String)"info.da.radius", (Object[])new Object[]{this.radius.getValue()}));
        tooltip.add((Component)Component.m_237110_((String)"info.da.opCost", (Object[])new Object[]{this.getRFCost()}));
    }

    public int compareTo(@NotNull Object o) {
        BombProjectileData data = (BombProjectileData)this.module.getData();
        BombProjectileData otherData = (BombProjectileData)((BombProjectileEntity)o).getModule().getData();
        return data.getRadius() - otherData.getRadius();
    }

    public static ArrayList<BombProjectileEntity> getSortedListFromStream(Stream<ModuleEntity<?>> bombEntities) {
        ArrayList<BombProjectileEntity> orderedBombEntities = new ArrayList<BombProjectileEntity>();
        bombEntities.forEach(entity -> orderedBombEntities.add((BombProjectileEntity)entity));
        Collections.sort(orderedBombEntities);
        return orderedBombEntities;
    }
}

