/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.client;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.smileycorp.hordes.client.render.ZombiePlayerRenderer;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.common.entities.HordesEntities;
import net.smileycorp.hordes.common.entities.PlayerZombie;
import net.smileycorp.hordes.config.ClientConfigHandler;
import net.smileycorp.hordes.hordeevent.capability.HordeEventClient;
import net.smileycorp.hordes.infection.client.ClientInfectionEventHandler;
import net.smileycorp.hordes.infection.network.CureEntityMessage;

@Mod.EventBusSubscriber(modid="hordes", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientHandler {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientInfectionEventHandler());
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)HordesEntities.ZOMBIE_PLAYER.get(), ctx -> new ZombiePlayerRenderer(ctx, ClientConfigHandler.getZombiePlayerColour(), Constants.loc("textures/entity/layer/zombie_player_outer_layer.png"), false, false));
        event.registerEntityRenderer((EntityType)HordesEntities.DROWNED_PLAYER.get(), ctx -> new ZombiePlayerRenderer(ctx, ClientConfigHandler.getDrownedPlayerColour(), Constants.loc("textures/entity/layer/drowned_player_outer_layer.png"), true, false));
        event.registerEntityRenderer((EntityType)HordesEntities.HUSK_PLAYER.get(), ctx -> new ZombiePlayerRenderer(ctx, ClientConfigHandler.getHuskPlayerColour(), Constants.loc("textures/entity/layer/husk_player_outer_layer.png"), false, true));
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ZombiePlayerRenderer.DEFAULT, () -> ZombiePlayerRenderer.createLayer(false));
        event.registerLayerDefinition(ZombiePlayerRenderer.SLIM, () -> ZombiePlayerRenderer.createLayer(true));
    }

    @SubscribeEvent
    public void renderNameplate(RenderNameTagEvent event) {
        if (event.getEntity() instanceof PlayerZombie) {
            event.setContent(event.getEntity().m_7770_());
        }
    }

    @SubscribeEvent
    public void fogColour(ViewportEvent.ComputeFogColor event) {
        if (!((Boolean)ClientConfigHandler.hordeEventTintsSky.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        LazyOptional optional = mc.f_91074_.getCapability(HordesCapabilities.HORDE_EVENT_CLIENT);
        if (optional.isPresent() && ((HordeEventClient)optional.orElseGet(null)).isHordeNight((Level)level)) {
            float d = level.m_104805_((float)event.getPartialTick()) * 1.4f;
            Color rgb = ClientConfigHandler.getHordeSkyColour();
            event.setRed((1.0f - d) * (float)rgb.getRed() / 255.0f + d * event.getRed());
            event.setGreen((1.0f - d) * (float)rgb.getGreen() / 255.0f + d * event.getGreen());
            event.setBlue((1.0f - d) * (float)rgb.getBlue() / 255.0f + d * event.getBlue());
        }
    }

    public static void playHordeSound(Vec3 vec3, ResourceLocation sound) {
        if (((Boolean)ClientConfigHandler.hordeSpawnSound.get()).booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            LocalPlayer player = mc.f_91074_;
            BlockPos pos = BlockPos.m_274561_((double)(player.m_20185_() + 10.0 * vec3.f_82479_), (double)player.m_20186_(), (double)(player.m_20189_() + 10.0 * vec3.f_82481_));
            float pitch = 1 + (level.f_46441_.m_188503_(6) - 3) / 10;
            level.m_5594_((Player)player, pos, SoundEvent.m_262824_((ResourceLocation)sound), SoundSource.HOSTILE, 0.5f, pitch);
        }
    }

    public static void setHordeDay(boolean hordeDay, int dayLength) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        LazyOptional optional = player.getCapability(HordesCapabilities.HORDE_EVENT_CLIENT);
        if (optional.isPresent()) {
            ((HordeEventClient)optional.orElseGet(null)).setHordeDay(hordeDay, dayLength);
        }
    }

    public static void displayMessage(String text) {
        Minecraft mc = Minecraft.m_91087_();
        Gui gui = mc.f_91065_;
        MutableComponent message = Component.m_237115_((String)text);
        message.m_6270_(Style.f_131099_.m_131148_(ClientConfigHandler.getHordeMessageColour()));
        if ((Integer)ClientConfigHandler.eventNotifyMode.get() == 1) {
            gui.m_93076_().m_93785_((Component)message);
        } else if ((Integer)ClientConfigHandler.eventNotifyMode.get() == 2) {
            gui.f_92990_ = message;
            gui.f_92991_ = (Integer)ClientConfigHandler.eventNotifyDuration.get();
            gui.f_92992_ = false;
        } else if ((Integer)ClientConfigHandler.eventNotifyMode.get() == 3) {
            gui.m_168684_(5, ((Integer)ClientConfigHandler.eventNotifyDuration.get()).intValue(), 5);
            gui.m_168711_((Component)message);
        }
    }

    public static void onInfect(boolean prevented) {
        LocalPlayer player;
        ClientLevel level;
        Minecraft mc;
        if ((Boolean)ClientConfigHandler.playerInfectSound.get() & !prevented) {
            mc = Minecraft.m_91087_();
            level = mc.f_91073_;
            player = mc.f_91074_;
            level.m_5594_((Player)player, player.m_20183_(), Constants.INFECT_SOUND, SoundSource.PLAYERS, 0.75f, level.f_46441_.m_188501_());
        }
        if (((Boolean)ClientConfigHandler.infectionProtectSound.get()).booleanValue() && prevented) {
            mc = Minecraft.m_91087_();
            level = mc.f_91073_;
            player = mc.f_91074_;
            level.m_5594_((Player)player, player.m_20183_(), Constants.IMMUNE_SOUND, SoundSource.PLAYERS, 0.75f, level.f_46441_.m_188501_());
        }
    }

    public static void processCureEntity(CureEntityMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        LivingEntity entity = message.getEntity((Level)level);
        level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11871_, entity.m_5720_(), 1.0f, 1.0f, true);
        RandomSource rand = level.f_46441_;
        for (int i = 0; i < 10; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123748_, entity.m_20185_() + (rand.m_188500_() - 0.5) * (double)entity.m_20205_() * 1.5, entity.m_20186_() + rand.m_188500_() * (double)entity.m_20206_(), entity.m_20189_() + (rand.m_188500_() - 0.5) * (double)entity.m_20205_() * 1.5, 0.0, 0.3, 0.0);
        }
    }
}

