/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.data.values;

import com.google.gson.JsonObject;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.data.values.ValueGetter;

public class PlayerPosGetter<T extends Comparable<T>, Number>
implements ValueGetter<T> {
    private final ValueGetter<String> value;
    private final DataType<T> type;

    private PlayerPosGetter(ValueGetter<String> value, DataType<T> type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public T get(Level level, LivingEntity entity, ServerPlayer player, RandomSource rand) {
        if (!this.type.isNumber().booleanValue()) {
            return null;
        }
        Direction.Axis axis = Direction.Axis.m_122473_((String)this.value.get(level, entity, player, rand));
        if (this.type == DataType.INT || this.type == DataType.LONG) {
            return (T)this.type.cast((Comparable)Integer.valueOf(player.m_20183_().m_123304_(axis)));
        }
        return (T)this.type.cast((Comparable)Double.valueOf(player.m_20182_().m_82507_(axis)));
    }

    public static <T extends Comparable<T>> ValueGetter deserialize(JsonObject object, DataType<T> type) {
        try {
            if (object.has("value")) {
                return new PlayerPosGetter(ValueGetter.readValue(DataType.STRING, object.get("value")), type);
            }
        }
        catch (Exception e) {
            HordesLogger.logError("invalid value for hordes:player_pos", e);
        }
        return null;
    }
}

