/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.capability;

import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.smileycorp.hordes.common.capability.HordesCapabilities;

public interface HordeEventClient {
    public boolean isHordeNight(Level var1);

    public void setHordeDay(boolean var1, int var2);

    public static class Provider
    implements ICapabilityProvider {
        protected HordeEventClient impl = new Impl();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
            return cap == HordesCapabilities.HORDE_EVENT_CLIENT ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }
    }

    public static class Impl
    implements HordeEventClient {
        private int day_length;
        private boolean horde_day;

        @Override
        public void setHordeDay(boolean hordeDay, int day_length) {
            if (day_length > 0) {
                this.day_length = day_length;
            }
            this.horde_day = hordeDay;
        }

        @Override
        public boolean isHordeNight(Level level) {
            if (this.day_length == 0 | !this.horde_day) {
                return false;
            }
            return (double)(level.m_46468_() % (long)this.day_length) >= 0.5 * (double)this.day_length;
        }
    }
}

