/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.util.json.JArray;
import com.probejs.util.json.JObject;
import com.probejs.util.json.JPrimitive;
import dev.latvian.mods.kubejs.recipe.schema.JsonRecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.recipe.schema.minecraft.SpecialRecipeSchema;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class RemoteSchema {
    public static final String SCHEMA_DOWNLOAD = "https://api.wolfgirl.moe/schemas/download/%s".formatted(SharedConstants.m_183709_().m_132493_());
    public static final String SCHEMA_CHECK = "https://api.wolfgirl.moe/schemas/mods/%s".formatted(SharedConstants.m_183709_().m_132493_());

    public static Set<String> getSupportedMods() throws IOException {
        HashSet<String> supported = new HashSet<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(SCHEMA_CHECK).openStream()));){
            JsonObject object = (JsonObject)ProbeJS.GSON.fromJson((Reader)reader, JsonObject.class);
            for (JsonElement mod : object.get("mods").getAsJsonArray()) {
                supported.add(mod.getAsString());
            }
        }
        return supported;
    }

    public static Map<String, String> getSchemas(Consumer<String> sendMessage) throws InterruptedException, IOException {
        Set<String> supported = RemoteSchema.getSupportedMods();
        Set serializers = RegistryInfo.RECIPE_SERIALIZER.entrySet().stream().map(Map.Entry::getKey).map(ResourceKey::m_135782_).map(ResourceLocation::m_135827_).filter(supported::contains).collect(Collectors.toSet());
        block0: for (Map.Entry entry : RecipeNamespace.getAll().entrySet()) {
            String key = (String)entry.getKey();
            RecipeNamespace namespace = (RecipeNamespace)entry.getValue();
            for (Map.Entry typeEntry : namespace.entrySet()) {
                RecipeSchemaType recipe = (RecipeSchemaType)typeEntry.getValue();
                if (recipe.schema == SpecialRecipeSchema.SCHEMA || recipe.schema == JsonRecipeSchema.SCHEMA) continue;
                serializers.remove(key);
                continue block0;
            }
        }
        if (serializers.isEmpty()) {
            return Map.of();
        }
        sendMessage.accept("Found %s mods having schemas available, downloading...".formatted(serializers.size()));
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(SCHEMA_DOWNLOAD)).POST(HttpRequest.BodyPublishers.ofString(ProbeJS.GSON.toJson((JsonElement)JObject.create().add("mods", JArray.create().addAll(serializers.stream().map(JPrimitive::new))).serialize()))).build();
        Map content = (Map)ProbeJS.GSON.fromJson(ProbeJS.HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString()).body(), Map.class);
        return new HashMap<String, String>(content);
    }

    public static void dumpSchemas(Consumer<String> sendMessage) {
        try {
            Map<String, String> schemas = RemoteSchema.getSchemas(sendMessage);
            for (Map.Entry<String, String> entry : schemas.entrySet()) {
                String schema = entry.getKey();
                String content = entry.getValue();
                BufferedWriter writer = Files.newBufferedWriter(ProbePaths.SCHEMA.resolve(schema), new OpenOption[0]);
                try {
                    writer.write(content);
                    if (schema.equals("prelude.js")) continue;
                    ProbeJS.LOGGER.info("Written schema file: %s".formatted(schema));
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            if (!schemas.isEmpty()) {
                sendMessage.accept("Schema generation done. Restart to register all downloaded schemas.");
            }
        }
        catch (Exception e) {
            ProbeJS.LOGGER.warn("Failed to dump schemas");
            e.printStackTrace();
        }
    }
}

