/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config;

import codechicken.lib.config.ConfigCallback;
import codechicken.lib.config.ConfigCategory;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public interface ConfigTag {
    public String getName();

    default public String getDesc() {
        return (String)(this.getParent() != null ? this.getParent().getDesc() + "." : "") + this.getName();
    }

    @Nullable
    public ConfigCategory getParent();

    public ConfigTag setComment(String var1);

    public ConfigTag setComment(String ... var1);

    public ConfigTag setComment(List<String> var1);

    public List<String> getComment();

    public ConfigTag syncTagToClient();

    public boolean requiresClientSync();

    default public void forceSync() {
        this.runSync(ConfigCallback.Reason.MANUAL);
    }

    public void runSync(ConfigCallback.Reason var1);

    public boolean isNetworkTag();

    default public void save() {
        if (this.getParent() != null) {
            this.getParent().save();
        }
    }

    public boolean isDirty();

    default public void delete() {
        if (this.getParent() != null) {
            this.getParent().delete(this.getName());
        }
    }

    public void reset();

    public ConfigTag copy();

    public void write(MCDataOutput var1);

    public void read(MCDataInput var1);

    public void resetFromNetwork();
}

