/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.geo;

import guideme.internal.shaded.lucene.geo.GeoUtils;
import guideme.internal.shaded.lucene.geo.Rectangle;
import java.util.Arrays;

final class EdgeTree {
    final double y1;
    final double y2;
    final double x1;
    final double x2;
    final double low;
    double max;
    EdgeTree left;
    EdgeTree right;
    private static final byte FALSE = 0;
    private static final byte TRUE = 1;
    private static final byte ON_EDGE = 2;

    private EdgeTree(double x1, double y1, double x2, double y2, double low, double max) {
        this.y1 = y1;
        this.x1 = x1;
        this.y2 = y2;
        this.x2 = x2;
        this.low = low;
        this.max = max;
    }

    protected boolean contains(double x, double y) {
        return this.containsPnPoly(x, y) > 0;
    }

    private byte containsPnPoly(double x, double y) {
        byte res = 0;
        if (y <= this.max) {
            if (y == this.y1 && y == this.y2 || (y <= this.y1 && y >= this.y2) != (y >= this.y1 && y <= this.y2)) {
                if (x == this.x1 && x == this.x2 || (x <= this.x1 && x >= this.x2) != (x >= this.x1 && x <= this.x2) && GeoUtils.orient(this.x1, this.y1, this.x2, this.y2, x, y) == 0) {
                    return 2;
                }
                if (this.y1 > y != this.y2 > y) {
                    byte by = res = x < (this.x2 - this.x1) * (y - this.y1) / (this.y2 - this.y1) + this.x1 ? (byte)1 : 0;
                }
            }
            if (this.left != null && ((res = (byte)(res ^ this.left.containsPnPoly(x, y))) & 2) == 2) {
                return 2;
            }
            if (this.right != null && y >= this.low && ((res = (byte)(res ^ this.right.containsPnPoly(x, y))) & 2) == 2) {
                return 2;
            }
        }
        assert (res >= 0 && res <= 2);
        return res;
    }

    boolean isPointOnLine(double x, double y) {
        if (y <= this.max) {
            boolean outside;
            double a1x = this.x1;
            double a1y = this.y1;
            double b1x = this.x2;
            double b1y = this.y2;
            boolean bl = outside = a1y < y && b1y < y || a1y > y && b1y > y || a1x < x && b1x < x || a1x > x && b1x > x;
            if (!outside && GeoUtils.orient(a1x, a1y, b1x, b1y, x, y) == 0) {
                return true;
            }
            if (this.left != null && this.left.isPointOnLine(x, y)) {
                return true;
            }
            if (this.right != null && y >= this.low && this.right.isPointOnLine(x, y)) {
                return true;
            }
        }
        return false;
    }

    boolean crossesTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, double bx, double by, double cx, double cy, boolean includeBoundary) {
        if (minY <= this.max) {
            boolean outside;
            double dy = this.y1;
            double ey = this.y2;
            double dx = this.x1;
            double ex = this.x2;
            boolean bl = outside = dy < minY && ey < minY || dy > maxY && ey > maxY || dx < minX && ex < minX || dx > maxX && ex > maxX;
            if (!outside && (includeBoundary ? GeoUtils.lineCrossesLineWithBoundary(dx, dy, ex, ey, ax, ay, bx, by) || GeoUtils.lineCrossesLineWithBoundary(dx, dy, ex, ey, bx, by, cx, cy) || GeoUtils.lineCrossesLineWithBoundary(dx, dy, ex, ey, cx, cy, ax, ay) : GeoUtils.lineCrossesLine(dx, dy, ex, ey, ax, ay, bx, by) || GeoUtils.lineCrossesLine(dx, dy, ex, ey, bx, by, cx, cy) || GeoUtils.lineCrossesLine(dx, dy, ex, ey, cx, cy, ax, ay))) {
                return true;
            }
            if (this.left != null && this.left.crossesTriangle(minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy, includeBoundary)) {
                return true;
            }
            if (this.right != null && maxY >= this.low && this.right.crossesTriangle(minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy, includeBoundary)) {
                return true;
            }
        }
        return false;
    }

    boolean crossesBox(double minX, double maxX, double minY, double maxY, boolean includeBoundary) {
        if (minY <= this.max) {
            boolean outside;
            double cy = this.y1;
            double dy = this.y2;
            double cx = this.x1;
            double dx = this.x2;
            if (Rectangle.containsPoint(cy, cx, minY, maxY, minX, maxX) || Rectangle.containsPoint(dy, dx, minY, maxY, minX, maxX)) {
                return true;
            }
            boolean bl = outside = cy < minY && dy < minY || cy > maxY && dy > maxY || cx < minX && dx < minX || cx > maxX && dx > maxX;
            if (!outside && (includeBoundary ? GeoUtils.lineCrossesLineWithBoundary(cx, cy, dx, dy, minX, minY, maxX, minY) || GeoUtils.lineCrossesLineWithBoundary(cx, cy, dx, dy, maxX, minY, maxX, maxY) || GeoUtils.lineCrossesLineWithBoundary(cx, cy, dx, dy, maxX, maxY, minX, maxY) || GeoUtils.lineCrossesLineWithBoundary(cx, cy, dx, dy, minX, maxY, minX, minY) : GeoUtils.lineCrossesLine(cx, cy, dx, dy, minX, minY, maxX, minY) || GeoUtils.lineCrossesLine(cx, cy, dx, dy, maxX, minY, maxX, maxY) || GeoUtils.lineCrossesLine(cx, cy, dx, dy, maxX, maxY, minX, maxY) || GeoUtils.lineCrossesLine(cx, cy, dx, dy, minX, maxY, minX, minY))) {
                return true;
            }
            if (this.left != null && this.left.crossesBox(minX, maxX, minY, maxY, includeBoundary)) {
                return true;
            }
            if (this.right != null && maxY >= this.low && this.right.crossesBox(minX, maxX, minY, maxY, includeBoundary)) {
                return true;
            }
        }
        return false;
    }

    boolean crossesLine(double minX, double maxX, double minY, double maxY, double a2x, double a2y, double b2x, double b2y, boolean includeBoundary) {
        if (minY <= this.max) {
            boolean outside;
            double a1x = this.x1;
            double a1y = this.y1;
            double b1x = this.x2;
            double b1y = this.y2;
            boolean bl = outside = a1y < minY && b1y < minY || a1y > maxY && b1y > maxY || a1x < minX && b1x < minX || a1x > maxX && b1x > maxX;
            if (!outside && (includeBoundary ? GeoUtils.lineCrossesLineWithBoundary(a1x, a1y, b1x, b1y, a2x, a2y, b2x, b2y) : GeoUtils.lineCrossesLine(a1x, a1y, b1x, b1y, a2x, a2y, b2x, b2y))) {
                return true;
            }
            if (this.left != null && this.left.crossesLine(minX, maxX, minY, maxY, a2x, a2y, b2x, b2y, includeBoundary)) {
                return true;
            }
            if (this.right != null && maxY >= this.low && this.right.crossesLine(minX, maxX, minY, maxY, a2x, a2y, b2x, b2y, includeBoundary)) {
                return true;
            }
        }
        return false;
    }

    static EdgeTree createTree(double[] x, double[] y) {
        EdgeTree[] edges = new EdgeTree[x.length - 1];
        for (int i = 1; i < x.length; ++i) {
            double x1 = x[i - 1];
            double y1 = y[i - 1];
            double x2 = x[i];
            double y2 = y[i];
            edges[i - 1] = new EdgeTree(x1, y1, x2, y2, Math.min(y1, y2), Math.max(y1, y2));
        }
        Arrays.sort(edges, (left, right) -> {
            int ret = Double.compare(left.low, right.low);
            if (ret == 0) {
                ret = Double.compare(left.max, right.max);
            }
            return ret;
        });
        return EdgeTree.createTree(edges, 0, edges.length - 1);
    }

    private static EdgeTree createTree(EdgeTree[] edges, int low, int high) {
        if (low > high) {
            return null;
        }
        int mid = low + high >>> 1;
        EdgeTree newNode = edges[mid];
        newNode.left = EdgeTree.createTree(edges, low, mid - 1);
        newNode.right = EdgeTree.createTree(edges, mid + 1, high);
        if (newNode.left != null) {
            newNode.max = Math.max(newNode.max, newNode.left.max);
        }
        if (newNode.right != null) {
            newNode.max = Math.max(newNode.max, newNode.right.max);
        }
        return newNode;
    }
}

