/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.provider;

import java.util.Optional;
import li.cil.manual.api.ManualModel;
import li.cil.manual.api.provider.RendererProvider;
import li.cil.manual.api.render.ContentRenderer;
import li.cil.manual.api.util.MatchResult;
import li.cil.manual.client.document.Strings;
import li.cil.manual.client.document.segment.render.MissingContentRenderer;
import li.cil.manual.client.document.segment.render.TextureContentRenderer;
import net.minecraft.resources.ResourceLocation;

public final class TextureRendererProvider
implements RendererProvider {
    private static final String[] EXTENSIONS = new String[]{".png", ".gif", ".jpg", ".jpeg", ".bmp", ".tga"};

    @Override
    public int sortOrder() {
        return 10000;
    }

    @Override
    public MatchResult matches(ManualModel manual) {
        return MatchResult.MATCH;
    }

    @Override
    public Optional<ContentRenderer> getRenderer(String path) {
        if (!TextureRendererProvider.hasSupportedExtension(path)) {
            return Optional.empty();
        }
        try {
            return Optional.of(new TextureContentRenderer(new ResourceLocation(path)));
        }
        catch (Throwable t) {
            return Optional.of(new MissingContentRenderer(Strings.NO_SUCH_IMAGE));
        }
    }

    private static boolean hasSupportedExtension(String path) {
        for (String extension : EXTENSIONS) {
            if (!path.endsWith(extension)) continue;
            return true;
        }
        return false;
    }
}

