/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FryingPanBlock;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrillBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    private final DyeColor color;

    public GrillBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.color = color;
    }

    public DyeColor getDyeColor() {
        return this.color;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, o -> baseShape)));
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof GrillBlockEntity) {
                GrillBlockEntity grill = (GrillBlockEntity)blockEntity;
                Containers.m_19010_((Level)level, (BlockPos)pos, grill.getCookingItems());
                Containers.m_19010_((Level)level, (BlockPos)pos, grill.getFuelItems());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && result.m_82434_() == Direction.UP && (blockEntity = level.m_7702_(pos)) instanceof GrillBlockEntity) {
            GrillBlockEntity grill = (GrillBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == ModItems.SPATULA.get()) {
                grill.flipItem(this.getGrillQuadrant(result));
                FryingPanBlock.playSpatulaScoopSound(level, pos.m_7494_(), 0.0);
            } else if (grill.addFuel(stack)) {
                stack.m_41774_(1);
                level.m_5594_(null, pos, SoundEvents.f_12654_, SoundSource.BLOCKS, 1.0f, 1.5f);
            } else if (!stack.m_41619_()) {
                if (grill.addCookingItem(stack, this.getGrillQuadrant(result), player.m_6350_().m_122416_()) && !player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            } else {
                grill.removeCookingItem(this.getGrillQuadrant(result));
            }
        }
        return InteractionResult.SUCCESS;
    }

    private int getGrillQuadrant(BlockHitResult hit) {
        BlockPos pos = hit.m_82425_();
        Vec3 hitVec = hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        return (hitVec.m_7096_() > 0.5 ? 1 : 0) + (hitVec.m_7094_() > 0.5 ? 2 : 0);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GrillBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return GrillBlock.createTicker(type, (BlockEntityType)ModBlockEntities.GRILL.get(), GrillBlockEntity::clientTick);
        }
        return GrillBlock.createTicker(type, (BlockEntityType)ModBlockEntities.GRILL.get(), GrillBlockEntity::serverTick);
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144282_, BlockTags.f_144286_);
    }
}

