/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.MailboxBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.INameable;
import com.mrcrayfish.furniture.refurbished.blockentity.RowedStorageBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.mail.Mailbox;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MailboxBlockEntity
extends RowedStorageBlockEntity
implements INameable {
    protected UUID uuid = UUID.randomUUID();
    protected WeakReference<Mailbox> mailboxRef;

    public MailboxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MAIL_BOX.get(), pos, state, (Integer)Config.SERVER.mailing.mailboxInventoryRows.get());
    }

    public UUID getId() {
        return this.uuid;
    }

    public void regenerateId() {
        this.uuid = UUID.randomUUID();
        this.m_6596_();
    }

    @Override
    public void setName(@Nullable ServerPlayer player, String name) {
        if (player == null) {
            return;
        }
        DeliveryService.get(player.f_8924_).ifPresent(service -> {
            if (!service.renameMailbox((Player)player, player.m_9236_(), this.f_58858_, name)) {
                player.m_213846_((Component)Utils.translation("gui", "rename_mailbox_failed", new Object[0]));
            }
        });
    }

    public boolean deliverItem(ItemStack mail) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) {
                this.m_6836_(i, mail);
                this.setUnchecked();
                return true;
            }
            if (stack.m_41613_() == stack.m_41741_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)mail) || stack.m_41613_() + mail.m_41613_() > stack.m_41741_()) continue;
            stack.m_41769_(mail.m_41613_());
            this.m_6596_();
            this.setUnchecked();
            return true;
        }
        return false;
    }

    public void setUnchecked() {
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)MailboxBlock.ENABLED, (Comparable)Boolean.valueOf(true)), 3);
    }

    public Mailbox getMailbox() {
        ServerLevel serverLevel;
        Optional<DeliveryService> optional;
        Level level;
        if (this.mailboxRef != null) {
            Mailbox mailbox = (Mailbox)this.mailboxRef.get();
            if (mailbox != null && !mailbox.removed().booleanValue()) {
                return mailbox;
            }
            this.mailboxRef = null;
        }
        if ((level = this.f_58857_) instanceof ServerLevel && (optional = DeliveryService.get((serverLevel = (ServerLevel)level).m_7654_())).isPresent()) {
            DeliveryService service = optional.get();
            Mailbox mailbox = service.getOrCreateMailBox(this);
            this.mailboxRef = new WeakReference<Mailbox>(mailbox);
            return mailbox;
        }
        return null;
    }

    protected Component m_6820_() {
        return Utils.translation("container", "mailbox", new Object[0]);
    }

    public Component m_5446_() {
        String customName;
        Mailbox mailbox = this.getMailbox();
        if (mailbox != null && (customName = (String)mailbox.customName().getValue()) != null && !customName.isBlank()) {
            return Component.m_237113_((String)customName);
        }
        return super.m_5446_();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("UUID", 11)) {
            this.uuid = tag.m_128342_("UUID");
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128362_("UUID", this.uuid);
    }
}

