/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.block.CuttingBoardBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.StorageJarBlockEntity;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class StorageJarRenderer
implements BlockEntityRenderer<StorageJarBlockEntity> {
    private final ItemRenderer renderer;
    private final Font font;
    private final EntityRenderDispatcher entityDispatcher;
    private final BlockEntityRenderDispatcher blockEntityDispatcher;

    public StorageJarRenderer(BlockEntityRendererProvider.Context context) {
        this.renderer = context.m_234447_();
        this.font = context.m_173586_();
        this.entityDispatcher = context.m_234446_();
        this.blockEntityDispatcher = context.m_173581_();
    }

    public void render(StorageJarBlockEntity storageJar, float partialTick, PoseStack poseStack, MultiBufferSource source, int light, int overlay) {
        ItemStack filter = storageJar.m_8020_(0);
        if (filter.m_41619_()) {
            return;
        }
        Direction direction = (Direction)storageJar.m_58900_().m_61143_((Property)CuttingBoardBlock.DIRECTION);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.015625, 0.5);
        poseStack.m_85841_(0.499f, 0.499f, 0.499f);
        for (int i = 0; i < storageJar.m_6643_(); ++i) {
            ItemStack stack = storageJar.m_8020_(i);
            if (stack.m_41619_()) continue;
            BakedModel model = this.renderer.m_174264_(stack, storageJar.m_58904_(), null, 0);
            float offset = model.m_7539_() ? 0.0375f : 0.0625f;
            this.drawItem(stack, storageJar.m_58904_(), direction, poseStack, source, light, overlay, !model.m_7539_(), offset);
        }
        poseStack.m_85849_();
        this.drawHoveredLabel(filter, storageJar.m_58899_(), poseStack, source);
    }

    private void drawItem(ItemStack stack, Level level, Direction facing, PoseStack poseStack, MultiBufferSource source, int light, int overlay, boolean flat, float offset) {
        poseStack.m_85836_();
        this.setupItemRotation(poseStack, facing, flat);
        this.renderer.m_269128_(stack, ItemDisplayContext.NONE, light, overlay, poseStack, source, level, 0);
        poseStack.m_85849_();
        poseStack.m_252880_(0.0f, offset, 0.0f);
        this.postDrawItem(poseStack, flat);
    }

    private void setupItemRotation(PoseStack poseStack, Direction facing, boolean flat) {
        if (!flat) {
            return;
        }
        poseStack.m_252781_(facing.m_253075_());
        poseStack.m_252781_(Axis.f_252436_.m_252961_((float)Math.PI));
    }

    private void postDrawItem(PoseStack poseStack, boolean flat) {
        if (flat) {
            poseStack.m_252781_(Axis.f_252436_.m_252961_(0.78149074f));
            return;
        }
        poseStack.m_85841_(0.998f, 0.998f, 0.998f);
    }

    private void drawHoveredLabel(ItemStack stack, BlockPos pos, PoseStack poseStack, MultiBufferSource source) {
        HitResult result = this.blockEntityDispatcher.f_112250_;
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos lookPos = ((BlockHitResult)result).m_82425_();
        if (!lookPos.equals((Object)pos)) {
            return;
        }
        if (stack.m_41619_()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.0, 0.5);
        poseStack.m_252781_(this.entityDispatcher.m_253208_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Component name = stack.m_41786_();
        int width = this.font.m_92852_((FormattedText)name);
        this.font.m_272077_(name, (float)(-width) / 2.0f, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), source, Font.DisplayMode.NORMAL, 0x22000000, 0xF000F0);
        poseStack.m_85849_();
    }
}

