/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.handlers.DESounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.registries.ForgeRegistries;

public class CommonMethods {
    private static final short gracePeriod = 100;

    public static boolean cheatCheck(ItemStack stack, Level world) {
        long containerTime = ItemNBTHelper.getLong((ItemStack)stack, (String)"cheatCheck", (long)0L);
        long serverTime = world.m_46467_();
        boolean isCheating = false;
        if (containerTime < serverTime - 100L && containerTime > 100L) {
            isCheating = true;
        }
        ItemNBTHelper.setLong((ItemStack)stack, (String)"cheatCheck", (long)serverTime);
        return isCheating;
    }

    public static void explodeEntity(Vector3 pos, Level world) {
        world.m_5594_(null, pos.pos(), (SoundEvent)DESounds.BEAM.get(), SoundSource.MASTER, 0.25f, 0.5f);
        world.m_5594_(null, pos.pos(), (SoundEvent)DESounds.FUSION_COMPLETE.get(), SoundSource.MASTER, 1.0f, 2.0f);
        if (world.f_46443_) {
            for (int i = 0; i < 5; ++i) {
            }
        }
    }

    public static Direction getHorizontalDirectionFromLookAngle(Vec2 lookAngle) {
        float r;
        for (r = lookAngle.f_82471_; r < 0.0f; r += 360.0f) {
        }
        if ((r %= 360.0f) > 315.0f || r <= 45.0f) {
            return Direction.SOUTH;
        }
        if (r > 45.0f && r <= 135.0f) {
            return Direction.WEST;
        }
        if (r > 135.0f && r <= 225.0f) {
            return Direction.NORTH;
        }
        return Direction.EAST;
    }

    public static Direction getDirectionFromLookAngle(Vec2 lookAngle) {
        if (lookAngle.f_82470_ > 45.0f) {
            return Direction.UP;
        }
        if (lookAngle.f_82470_ < -45.0f) {
            return Direction.DOWN;
        }
        return CommonMethods.getHorizontalDirectionFromLookAngle(lookAngle);
    }

    public static boolean overwriteBlockStateUnsafe(Level world, BlockPos pos, BlockState blockState) {
        pos = pos.m_7949_();
        int x = pos.m_123341_() & 0xF;
        int y = pos.m_123342_() & 0xF;
        int z = pos.m_123343_() & 0xF;
        LevelChunk chunk = world.m_46745_(pos);
        if (!world.m_46749_(pos)) {
            return false;
        }
        if (world.f_46443_) {
            chunk.m_6978_(pos, blockState, false);
            return true;
        }
        LevelChunkSection chunksection = chunk.m_183278_(chunk.m_151564_(pos.m_123342_()));
        BlockEntity oldTile = world.m_7702_(pos);
        BlockState oldState = (BlockState)chunksection.m_63019_().m_63127_(x, y, z, (Object)blockState);
        if (oldState == blockState) {
            return true;
        }
        if (blockState.m_155947_() && oldTile != null && !BlockEntityType.m_58954_((BlockEntityType)oldTile.m_58903_()).toString().contentEquals(ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()).toString())) {
            world.m_151523_(((EntityBlock)blockState.m_60734_()).m_142194_(pos, blockState));
        }
        return true;
    }

    public static CompoundTag createFakeNBT(BlockPos pos) {
        CompoundTag fakeNBT = new CompoundTag();
        fakeNBT.m_128405_("x", pos.m_123341_());
        fakeNBT.m_128405_("y", pos.m_123342_());
        fakeNBT.m_128405_("z", pos.m_123343_());
        return fakeNBT;
    }

    public static class BlockStorage {
        private Level oldWorld;
        private BlockPos oldPos;
        public BlockState blockState;
        public CompoundTag tileNBT;

        public BlockStorage(Level world, BlockPos pos) {
            this.storeBlockAt(world, pos);
        }

        public BlockStorage(Level world, BlockPos pos, boolean removeBlock) {
            this.storeBlockAt(world, pos, removeBlock);
        }

        public BlockStorage(Level world, BlockPos pos, BlockState blockState, CompoundTag tileNBT) {
            this.oldWorld = world;
            this.oldPos = pos;
            this.blockState = blockState;
            this.tileNBT = tileNBT;
        }

        public void storeBlockAt(Level world, BlockPos pos) {
            this.storeBlockAt(world, pos, false);
        }

        public void storeBlockAt(Level world, BlockPos pos, boolean removeBlock) {
            this.oldWorld = world;
            this.oldPos = pos;
            this.blockState = world.m_8055_(pos);
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity != null) {
                this.tileNBT = tileEntity.serializeNBT();
                if (removeBlock) {
                    world.m_7702_(pos).deserializeNBT(CommonMethods.createFakeNBT(pos));
                    CommonMethods.overwriteBlockStateUnsafe(world, pos, Blocks.f_50016_.m_49966_());
                }
            }
        }

        public boolean restoreBlockAt(Level world, BlockPos pos, @Nullable Vec2 rotation) {
            return this.restoreBlockAt(world, pos, rotation, true);
        }

        public boolean restoreBlockAt(Level world, BlockPos pos, @Nullable Vec2 rotation, boolean permanent) {
            if (this.blockState != null) {
                String tileID;
                String savedID;
                BlockEntity tileEntity;
                int flags;
                BlockStorage oldBlock = new BlockStorage(world, pos, false);
                int n = flags = permanent ? 3 : 0;
                if (permanent) {
                    world.m_7731_(pos, this.blockState, flags);
                } else {
                    CommonMethods.overwriteBlockStateUnsafe(world, pos, this.blockState);
                }
                BlockState newState = world.m_8055_(pos);
                if (newState.m_60734_() != this.blockState.m_60734_()) {
                    oldBlock.restoreBlock();
                    return false;
                }
                if (this.blockState.m_155947_() && this.tileNBT != null && this.tileNBT.m_128441_("id") && (tileEntity = world.m_7702_(pos)) != null && (savedID = this.tileNBT.m_128461_("id")).contentEquals(tileID = BlockEntityType.m_58954_((BlockEntityType)tileEntity.m_58903_()).toString())) {
                    tileEntity.deserializeNBT(this.tileNBT);
                    tileEntity.m_142339_(world);
                    if (permanent) {
                        tileEntity.requestModelDataUpdate();
                    }
                }
                if (rotation != null) {
                    this.blockState.m_61148_().forEach((prop, comp) -> {
                        if (prop instanceof DirectionProperty) {
                            Direction dir;
                            DirectionProperty dirProp = (DirectionProperty)prop;
                            if (dirProp == BlockStateProperties.f_61372_) {
                                this.blockState = (BlockState)this.blockState.m_61124_((Property)dirProp, (Comparable)CommonMethods.getDirectionFromLookAngle(rotation));
                            } else if (dirProp == BlockStateProperties.f_61374_ && (dir = CommonMethods.getHorizontalDirectionFromLookAngle(rotation)) != null) {
                                this.blockState = (BlockState)this.blockState.m_61124_((Property)dirProp, (Comparable)dir);
                            }
                        }
                    });
                }
                if (permanent) {
                    world.m_7731_(pos, this.blockState, flags);
                } else {
                    CommonMethods.overwriteBlockStateUnsafe(world, pos, this.blockState);
                }
                return true;
            }
            return false;
        }

        public void restoreBlock() {
            this.restoreBlock(null);
        }

        public void restoreBlock(@Nullable Vec2 rotation) {
            this.restoreBlock(rotation, true);
        }

        public void restoreBlock(@Nullable Vec2 rotation, boolean permanent) {
            this.restoreBlockAt(this.oldWorld, this.oldPos, rotation, permanent);
        }

        public CompoundTag storeBlockInTag(CompoundTag nbt) {
            return BlockStorage.storeBlockInTag(this.blockState, this.tileNBT, nbt);
        }

        public static CompoundTag storeBlockInTag(Level world, BlockPos pos, boolean removeBlock, CompoundTag nbt) {
            BlockStorage block = new BlockStorage(world, pos, removeBlock);
            BlockStorage.storeBlockInTag(block.blockState, block.tileNBT, nbt);
            if (removeBlock) {
                CommonMethods.overwriteBlockStateUnsafe(world, pos, Blocks.f_50016_.m_49966_());
            }
            return nbt;
        }

        public static CompoundTag storeBlockInTag(BlockState blockState, CompoundTag tileNBT, CompoundTag nbt) {
            String blockName = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()).toString();
            nbt.m_128359_("storedBlock", blockName);
            nbt.m_128405_("storedBlockState", Block.m_49956_((BlockState)blockState));
            if (tileNBT != null) {
                nbt.m_128365_("storedBlockEntity", (Tag)tileNBT);
            }
            return nbt;
        }

        public static boolean restoreBlockFromTag(Level world, BlockPos pos, @Nullable Vec2 rotation, CompoundTag nbt, boolean permanent, boolean clearNBT) {
            BlockStorage newBlock;
            if (nbt == null) {
                return false;
            }
            Block block = BlockStorage.getBlockFromTag(nbt);
            BlockState blockState = BlockStorage.getBlockStateFromTag(nbt);
            if (block == null || blockState == null) {
                return false;
            }
            if (blockState.m_60734_() != block) {
                blockState = block.m_49966_();
            }
            CompoundTag tileNBT = null;
            if (nbt.m_128441_("storedBlockEntity")) {
                tileNBT = (CompoundTag)nbt.m_128423_("storedBlockEntity");
            }
            if (!(newBlock = new BlockStorage(world, pos, blockState, tileNBT)).restoreBlockAt(world, pos, rotation, permanent)) {
                return false;
            }
            if (clearNBT) {
                nbt.m_128473_("storedBlock");
                nbt.m_128473_("storedBlockState");
                nbt.m_128473_("storedBlockEntity");
            }
            return true;
        }

        public static Block getBlockFromTag(CompoundTag nbt) {
            return nbt == null ? null : (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("storedBlock")));
        }

        public static BlockState getBlockStateFromTag(CompoundTag nbt) {
            return nbt != null && nbt.m_128441_("storedBlockState") ? Block.m_49803_((int)nbt.m_128451_("storedBlockState")) : null;
        }
    }
}

