/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.blocks.tileentity;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.ArrayList;
import net.foxmcloud.draconicadditions.blocks.tileentity.TileChaosHolderBase;
import net.foxmcloud.draconicadditions.inventory.ChaosExtractorMenu;
import net.foxmcloud.draconicadditions.lib.DAContent;
import net.foxmcloud.draconicadditions.modules.DAModuleTypes;
import net.foxmcloud.draconicadditions.modules.entities.StableChaosEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class TileChaosExtractor
extends TileChaosHolderBase
implements IChangeListener,
IInteractTile,
MenuProvider {
    private int rfCost = 10000;
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", false, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));

    public TileChaosExtractor(BlockPos pos, BlockState state) {
        super((BlockEntityType)DAContent.tileChaosExtractor.get(), pos, state);
        this.itemHandler = new TileItemStackHandler((BlockEntity)this, 2);
        this.opStorage = new ModularOPStorage((TileBCore)this, 1000000L, 50000L, 50000L);
        this.capManager.setManaged("energy", CapabilityOP.OP, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.capManager.setInternalManaged("inventory", ForgeCapabilities.ITEM_HANDLER, (INBTSerializable)this.itemHandler).saveBoth().syncTile();
        this.itemHandler.setStackValidator(this::isItemValidForSlot);
        this.setupPowerSlot((IItemHandler)this.itemHandler, 1, (IOPStorage)this.opStorage, false);
        this.installIOTracker(this.opStorage);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            if (this.active.get()) {
                this.f_58857_.m_7785_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5, (SoundEvent)DESounds.BEAM.get(), SoundSource.BLOCKS, 0.2f, 1.0f, false);
            }
        } else {
            ItemStack stack = this.itemHandler.getStackInSlot(0);
            boolean valid = this.isTileEnabled() && !stack.m_41619_() && this.opStorage.getEnergyStored() >= this.rfCost && this.isItemValidForSlot(0, stack) && this.chaos.get() <= this.getMaxChaos() - TileChaosExtractor.calcChaos(stack);
            this.active.set(valid);
            if (valid) {
                this.extractChaos();
            }
        }
    }

    public void extractChaos() {
        StableChaosEntity entity;
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (TileChaosExtractor.chaosID(stack.m_41720_()) == 5) {
            this.opStorage.extractOP((long)this.rfCost, false);
            this.chaos.add(TileChaosExtractor.calcChaos(stack));
            if (this.chaos.get() > this.getMaxChaos()) {
                this.chaos.set(this.getMaxChaos());
            }
            if (stack.m_41613_() > 1) {
                stack.m_41774_(1);
                Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)((Item)DEContent.DRAGON_HEART.get()).m_7968_());
            } else {
                stack = ((Item)DEContent.DRAGON_HEART.get()).m_7968_();
            }
            this.itemHandler.setStackInSlot(0, stack);
        } else if (this.chaos.get() < this.getMaxChaos() && (entity = this.getFirstValidChaosEntity(stack)) != null) {
            this.opStorage.extractOP((long)this.rfCost, false);
            this.chaos.add(-entity.modifyChaos(-1));
        }
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index == 1 ? EnergyUtils.isEnergyItem((ItemStack)stack) : TileChaosExtractor.chaosID(stack.m_41720_()) == 5 || this.getFirstValidChaosEntity(stack) != null;
    }

    private StableChaosEntity getFirstValidChaosEntity(ItemStack stack) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElse(null);
        if (host != null) {
            ArrayList<StableChaosEntity> entities = StableChaosEntity.getSortedListFromStream(host.getEntitiesByType(DAModuleTypes.STABLE_CHAOS));
            for (StableChaosEntity entity : entities) {
                if (entity.getChaos() <= 0) continue;
                return entity;
            }
        }
        return null;
    }

    public AbstractContainerMenu m_7208_(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new ChaosExtractorMenu(currentWindowIndex, player.m_150109_(), this);
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        }
        return true;
    }
}

