/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.blocks.tileentity;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.data.ShieldData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.SimpleModuleHost;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import net.foxmcloud.draconicadditions.lib.DAContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class TileChaosHolderBase
extends TileBCore
implements IRSSwitchable {
    public OPStorage opStorage;
    public TileItemStackHandler itemHandler;
    protected static final int maxCharge = 200;
    public final ManagedInt chaos = (ManagedInt)this.register((IManagedData)new ManagedInt("chaos", 0, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public SimpleModuleHost moduleHost = new SimpleModuleHost(TechLevel.CHAOTIC, 6, 6, ModuleCfg.removeInvalidModules, new ModuleCategory[]{ModuleCategory.ENERGY}).addAdditionalType(ModuleTypes.SHIELD_BOOST);

    public int getMaxChaos() {
        return ((ShieldData)this.moduleHost.getModuleData(ModuleTypes.SHIELD_BOOST, (ModuleData)new ShieldData(0, 0.0))).shieldCapacity() * 10;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canRemoveModule(ModuleEntity<?> entity) {
        ModuleData moduleData = entity.getModule().getData();
        if (!(moduleData instanceof ShieldData)) return true;
        ShieldData data = (ShieldData)moduleData;
        if (this.getMaxChaos() - data.shieldCapacity() * 10 >= this.chaos.get()) return true;
        return false;
    }

    public TileChaosHolderBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.capManager.setManaged("module_host", DECapabilities.MODULE_HOST_CAPABILITY, (INBTSerializable)this.moduleHost, new Direction[0]).saveBoth().syncContainer();
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    public static int calcChaos(ItemStack stack) {
        switch (TileChaosHolderBase.chaosID(stack.m_41720_())) {
            case 1: {
                return 11664;
            }
            case 2: {
                return 1296;
            }
            case 3: {
                return 144;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 20000;
            }
        }
        return 0;
    }

    public int calcCharge(ItemStack stack) {
        switch (TileChaosHolderBase.chaosID(stack.m_41720_())) {
            case 1: {
                return 133;
            }
            case 2: {
                return 50;
            }
            case 3: {
                return 25;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 200;
            }
        }
        return 0;
    }

    public static int chaosID(Item item) {
        if (item == DEContent.CHAOS_SHARD.get()) {
            return 1;
        }
        if (item == DEContent.CHAOS_FRAG_LARGE.get()) {
            return 2;
        }
        if (item == DEContent.CHAOS_FRAG_MEDIUM.get()) {
            return 3;
        }
        if (item == DEContent.CHAOS_FRAG_SMALL.get()) {
            return 4;
        }
        if (item == DAContent.chaosHeart.get()) {
            return 5;
        }
        return 0;
    }
}

