/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.items.curios;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.IInvCharge;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.init.TechProperties;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.tools.DraconiumCapacitor;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.foxmcloud.draconicadditions.CommonMethods;
import net.foxmcloud.draconicadditions.DAConfig;
import net.foxmcloud.draconicadditions.items.IModularEnergyItem;
import net.foxmcloud.draconicadditions.modules.DAModuleTypes;
import net.foxmcloud.draconicadditions.modules.data.TickAccelData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotTypePreset;

public class ModularHarness
extends Item
implements IModularEnergyItem,
IInvCharge {
    public static final ModuleCategory HARNESS = new ModuleCategory();
    private static final String receive = "receive_energy_from_machine";
    private static final String tickAccelSpeed = "tick_accel.speed";
    private TechLevel techLevel;

    public ModularHarness(TechProperties props) {
        super((Item.Properties)props);
        this.techLevel = props.getTechLevel();
    }

    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    public boolean canCharge(ItemStack stack, LivingEntity player, boolean isHeld) {
        return !ModularHarness.isReceiving(stack);
    }

    public void handleTick(ItemStack stack, LivingEntity entity, @Nullable EquipmentSlot slot, boolean inEquipModSlot) {
        EntityBlock block;
        BlockEntityTicker ticker;
        BlockPos pos;
        boolean validEquipSlot;
        boolean bl = slot != null ? false : (validEquipSlot = inEquipModSlot && DAConfig.harnessTickInCuriosSlot);
        if (!validEquipSlot && !DAConfig.harnessTickOutOfCuriosSlot || !ModularHarness.hasAttachedBlockEntity(stack, entity.m_9236_())) {
            return;
        }
        Level world = entity.m_9236_();
        if (!world.m_46739_(pos = entity.m_20183_().m_7494_())) {
            return;
        }
        CommonMethods.BlockStorage oldBlock = new CommonMethods.BlockStorage(world, pos, false);
        BlockEntity tile = ModularHarness.placeAndGetBlockEntity(world, pos, entity.m_20155_(), stack);
        if (tile == null) {
            return;
        }
        BlockState state = tile.m_58900_();
        stack.getCapability(DECapabilities.OP_STORAGE).ifPresent(e -> {
            Block patt4708$temp;
            IOPStorage teStorage = EnergyUtils.getStorage((BlockEntity)tile, null);
            if (teStorage != null) {
                if (ModularHarness.isReceiving(stack)) {
                    e.receiveOP(EnergyUtils.extractEnergy((BlockEntity)tile, (long)Math.min(e.receiveOP(e.maxReceive(), true), teStorage.getOPStored()), null, (boolean)false), false);
                    ((DraconiumCapacitor)DEContent.CAPACITOR_CHAOTIC.get()).handleTick(stack, entity, slot, inEquipModSlot);
                } else if (tile != null) {
                    e.extractOP(EnergyUtils.insertEnergy((BlockEntity)tile, (long)e.extractOP(e.maxExtract(), true), null, (boolean)false), false);
                }
            }
            if ((patt4708$temp = state.m_60734_()) instanceof EntityBlock) {
                EntityBlock block = (EntityBlock)patt4708$temp;
                BlockEntityTicker ticker = block.m_142354_(world, state, tile.m_58903_());
                if (ticker == null) {
                    return;
                }
                int ticksToProcess = ModularHarness.getCurrentTickSpeed(stack) - 1;
                int rfCost = ModularHarness.getRFCostForTicks(ticksToProcess);
                if (e.extractOP((long)rfCost, true) >= (long)rfCost) {
                    e.extractOP((long)rfCost, false);
                    for (int i = 0; i < ticksToProcess; ++i) {
                        ticker.m_155252_(world, pos, state, tile);
                    }
                }
            }
        });
        Block block2 = state.m_60734_();
        if (block2 instanceof EntityBlock && (ticker = (block = (EntityBlock)block2).m_142354_(world, state, tile.m_58903_())) != null) {
            ticker.m_155252_(world, pos, state, tile);
        }
        ModularHarness.storeBlockEntity(world, pos, stack, entity, false);
        oldBlock.restoreBlock(null, false);
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, this.techLevel.index, 2, "harness", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(new ModuleCategory[]{ModuleCategory.ENERGY, HARNESS});
        host.addPropertyBuilder(props -> {
            TickAccelData speed;
            props.add(new BooleanProperty(receive, false));
            props.add(new BooleanProperty("charge_held_item", false));
            props.add(new BooleanProperty("charge_armor", false));
            props.add(new BooleanProperty("charge_hot_bar", false));
            props.add(new BooleanProperty("charge_main", false));
            if (EquipmentManager.equipModLoaded()) {
                props.add(new BooleanProperty("charge_" + EquipmentManager.equipModID(), false));
            }
            if ((speed = (TickAccelData)host.getModuleData(DAModuleTypes.TICK_ACCEL)) != null) {
                Supplier<Integer> speedGetter = () -> {
                    TickAccelData data = (TickAccelData)host.getModuleData(DAModuleTypes.TICK_ACCEL);
                    return data == null ? 0 : data.getSpeed();
                };
                props.add(new IntegerProperty(tickAccelSpeed, speedGetter.get().intValue()).min(0).max(speedGetter).setFormatter(ConfigProperty.IntegerFormatter.RAW));
            }
        });
        return host;
    }

    @Override
    @Nullable
    public ModularOPStorage createOPStorage(ItemStack stack, ModuleHostImpl host) {
        long capacity = (long)((double)EquipCfg.getBaseEnergy((TechLevel)this.techLevel) * DAConfig.harnessCapacityMultiplier);
        return new ModularOPStorage((ModuleHost)host, capacity, capacity / 64L).setIOMode(true, true);
    }

    public boolean canEquip(ItemStack stack, LivingEntity livingEntity, String identifier) {
        return identifier.equals(SlotTypePreset.BACK.getIdentifier());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        String name = ModularHarness.getAttachedName(stack);
        if (name != null && name != "") {
            tooltip.add((Component)Component.m_237115_((String)"info.da.modular_harness.storedBlock").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)ModularHarness.getAttachedName(stack)).m_130940_(ChatFormatting.GRAY)));
            String rf = Utils.formatNumber((long)ModularHarness.getRFCostForTicks(ModularHarness.getCurrentTickSpeed(stack)));
            tooltip.add((Component)Component.m_237110_((String)"info.da.opCost", (Object[])new Object[]{rf}).m_130940_(ChatFormatting.GRAY));
        }
        EnergyUtils.addEnergyInfo((ItemStack)stack, tooltip);
    }

    public static int getCurrentTickSpeed(ItemStack stack) {
        PropertyProvider props = (PropertyProvider)stack.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY).orElse(null);
        int ticks = 1 + (props != null && props.getInt(tickAccelSpeed) != null ? props.getInt(tickAccelSpeed).getValue() : 0);
        return ticks;
    }

    public static int getRFCostForTicks(int ticks) {
        return ticks > 1 ? (int)Math.pow(400.0, (double)ticks * 0.25 + 0.25) : 0;
    }

    public static boolean storeBlockEntity(Level world, BlockPos pos, ItemStack stack, LivingEntity entity, boolean removeBlock) {
        if (world instanceof ServerLevel) {
            if (world.m_7702_(pos) != null) {
                CommonMethods.BlockStorage block = new CommonMethods.BlockStorage(world, pos, removeBlock);
                block.storeBlockInTag(stack.m_41784_());
            } else {
                entity.m_213846_((Component)Component.m_237115_((String)"info.da.modular_harness.cantmove"));
                return false;
            }
        }
        return true;
    }

    public static BlockEntity placeAndGetBlockEntity(Level world, BlockPos pos, @Nullable Vec2 rotation, ItemStack stack) {
        if (CommonMethods.BlockStorage.restoreBlockFromTag(world, pos, rotation, stack.m_41783_(), false, false)) {
            return world.m_7702_(pos);
        }
        return null;
    }

    public static String getAttachedName(ItemStack stack) {
        if (stack.m_41783_() != null) {
            Block block = CommonMethods.BlockStorage.getBlockFromTag(stack.m_41783_());
            return block == null || block == Blocks.f_50016_ ? null : block.m_49954_().getString();
        }
        return null;
    }

    public static boolean hasAttachedBlockEntity(ItemStack stack, Level world) {
        return stack.m_41784_().m_128441_("storedBlockState");
    }

    public static boolean isReceiving(ItemStack stack) {
        BooleanProperty isReceiving = new BooleanProperty(null, false);
        stack.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY).ifPresent(props -> isReceiving.setValue(props.getBool(receive).getValue()));
        return isReceiving.getValue();
    }

    public boolean m_142522_(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int m_142158_(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return this.damageBarColour(stack);
    }
}

