/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.modules.entities;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.TileModuleContext;
import com.brandon3055.draconicevolution.blocks.reactor.ProcessExplosion;
import com.brandon3055.draconicevolution.lib.WTFException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.foxmcloud.draconicadditions.modules.data.StableChaosData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class StableChaosEntity
extends ModuleEntity<StableChaosData>
implements Comparable<StableChaosEntity> {
    private static final double rfCostLimit = 1000000.0;
    private int chaos = 0;
    private float instability = 0.0f;

    public StableChaosEntity(Module<StableChaosData> module) {
        super(module);
    }

    public void tick(ModuleContext moduleContext) {
        if (!EffectiveSide.get().isServer()) {
            return;
        }
        if (this.chaos <= 0) {
            this.instability = 0.0f;
            return;
        }
        if (this.instability > 0.0f) {
            long rfCost = this.getRFCost();
            IOPStorage storage = moduleContext.getOpStorage();
            if (storage != null && storage.modifyEnergyStored(-rfCost) == Math.abs(rfCost)) {
                StableChaosData data = (StableChaosData)this.module.getData();
                this.instability = (float)((double)this.instability - (this.instability > (float)data.getMaxInstability() ? (double)Math.min(10.0f, this.instability - (float)data.getMaxInstability()) : 0.25));
            } else {
                ServerLevel level;
                BlockPos expLoc;
                if (moduleContext instanceof StackModuleContext) {
                    StackModuleContext stackContext = (StackModuleContext)moduleContext;
                    expLoc = stackContext.getEntity().m_20183_();
                    level = (ServerLevel)stackContext.getEntity().m_9236_();
                } else if (moduleContext instanceof TileModuleContext) {
                    TileModuleContext tileContext = (TileModuleContext)moduleContext;
                    expLoc = tileContext.getTile().m_58899_();
                    level = (ServerLevel)tileContext.getTile().m_58904_();
                } else {
                    throw new WTFException("ModuleContext for StableChaosEntity wasn't in a stack or a tile?!");
                }
                ProcessExplosion explosionProcess = new ProcessExplosion(expLoc, 10, level, 0);
                ProcessHandler.addProcess((IProcess)explosionProcess);
                this.chaos = 0;
                this.instability = 0.0f;
            }
        }
    }

    public int getChaos() {
        return this.chaos;
    }

    public float getInstability() {
        return this.instability;
    }

    public long getRFCost() {
        return (long)Math.min(Math.pow(4.0, Math.min(this.instability, 1250.0f) / 40.0f) * (double)(this.chaos / 10), 1000000.0);
    }

    public int modifyChaos(int amount) {
        StableChaosData data = (StableChaosData)this.module.getData();
        int chaosToMod = amount >= 0 ? Math.min(data.getMaxChaos() - this.chaos, amount) : Math.max(-this.chaos, amount);
        this.chaos += chaosToMod;
        this.instability += (float)Math.abs(chaosToMod);
        return chaosToMod;
    }

    public void writeToItemStack(ItemStack stack, ModuleContext context) {
        super.writeToItemStack(stack, context);
        stack.m_41784_().m_128405_("chaos", this.chaos);
        stack.m_41784_().m_128350_("instability", this.instability);
    }

    public void readFromItemStack(ItemStack stack, ModuleContext context) {
        super.readFromItemStack(stack, context);
        if (stack.m_41782_()) {
            this.chaos = stack.m_41784_().m_128451_("chaos");
            this.instability = stack.m_41784_().m_128451_("instability");
        }
    }

    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128405_("chaos", this.chaos);
        compound.m_128350_("instability", this.instability);
    }

    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.chaos = compound.m_128451_("chaos");
        this.instability = compound.m_128451_("instability");
    }

    public void addToolTip(List<Component> tooltip) {
        StableChaosData data = (StableChaosData)this.module.getData();
        tooltip.add((Component)Component.m_237110_((String)"info.da.storedChaos", (Object[])new Object[]{this.chaos, data.getMaxChaos()}));
        tooltip.add((Component)Component.m_237110_((String)"info.da.instability", (Object[])new Object[]{Float.valueOf(this.instability), data.getMaxInstability()}));
        tooltip.add((Component)Component.m_237110_((String)"info.da.opCost", (Object[])new Object[]{this.getRFCost()}));
    }

    @Override
    public int compareTo(StableChaosEntity o) {
        StableChaosData data = (StableChaosData)this.module.getData();
        StableChaosData otherData = (StableChaosData)o.getModule().getData();
        return data.getMaxInstability() - otherData.getMaxInstability();
    }

    public static ArrayList<StableChaosEntity> getSortedListFromStream(Stream<ModuleEntity<?>> chaosEntities) {
        ArrayList<StableChaosEntity> orderedChaosEntities = new ArrayList<StableChaosEntity>();
        chaosEntities.forEach(entity -> orderedChaosEntities.add((StableChaosEntity)entity));
        Collections.sort(orderedChaosEntities);
        return orderedChaosEntities;
    }
}

