/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.smarterfarmers.EatFoodGoal;
import net.mehvahdjukaar.smarterfarmers.mixins.VillagerAccessor;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmarterFarmers {
    public static final String MOD_ID = "smarterfarmers";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean QUARK = PlatHelper.isModLoaded((String)"quark");
    public static final TagKey<Block> SPECIAL_HARVESTABLE = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("smarterfarmers", "harvestable_plant"));
    public static final TagKey<Block> HARVESTABLE_ON_DIRT_NO_REPLANT = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("smarterfarmers", "harvestable_on_dirt_no_replant"));
    public static final TagKey<Block> HARVESTABLE_ON_DIRT = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("smarterfarmers", "harvestable_on_dirt"));
    public static final TagKey<Block> VALID_FARMLAND = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("smarterfarmers", "farmer_plantable_on"));
    public static final TagKey<Block> FARMLAND_DIRT = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("smarterfarmers", "farmland_dirt"));
    public static final TagKey<Item> MEAT = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "food/meat"));
    public static final Supplier<Boolean> PICKUP_FOOD;
    public static final Supplier<Boolean> EAT_FOOD;
    public static final Supplier<Boolean> DEBUG_RENDERERS;
    public static final Supplier<Integer> TIME_TO_HARVEST;

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void commonInit() {
        MoonlightEventsHelper.addListener(SmarterFarmers::onVillagerBrainInitialize, IVillagerBrainEvent.class);
    }

    public static void setup() {
        try {
            HashMap<Item, Integer> newMap = new HashMap<Item, Integer>(Villager.f_35369_);
            for (Item i : BuiltInRegistries.f_257033_) {
                if (!i.m_41472_() || i.m_41460_(new ItemStack((ItemLike)i)) != Rarity.COMMON || i.m_204114_().m_203656_(MEAT) || i instanceof BowlFoodItem || i instanceof HoneyBottleItem) continue;
                newMap.put(i, (int)Math.max(1.0f, (float)(i.m_41473_().m_38744_() * 2) / 3.0f));
            }
            VillagerAccessor.setFoodPoints(newMap);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to add custom foods to villagers");
        }
    }

    public static void onVillagerBrainInitialize(IVillagerBrainEvent event) {
        if (!event.getVillager().m_6162_() && EAT_FOOD.get().booleanValue()) {
            event.addTaskToActivity(Activity.f_37983_, Pair.of((Object)7, (Object)((Object)new EatFoodGoal(100, 140))));
        }
    }

    public static void spawnEatingParticles(AbstractVillager villager) {
        Vec3 pos = new Vec3(0.0, 0.0, 0.4);
        pos = pos.m_82524_(-villager.f_20883_ * ((float)Math.PI / 180));
        pos = pos.m_82520_(villager.m_20185_(), villager.m_20188_(), villager.m_20189_());
        ItemStack stack = villager.m_21205_();
        Level level = villager.m_9236_();
        level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), pos.f_82479_ + (double)Mth.m_216283_((RandomSource)level.f_46441_, (float)-0.05f, (float)0.05f), pos.f_82480_ - 0.4 + (double)Mth.m_216283_((RandomSource)level.f_46441_, (float)-0.05f, (float)0.05f), pos.f_82481_ + (double)Mth.m_216283_((RandomSource)level.f_46441_, (float)-0.05f, (float)0.05f), 0.03, 0.05, 0.03);
    }

    static {
        ConfigBuilder builder = ConfigBuilder.create((String)MOD_ID, (ConfigType)ConfigType.COMMON);
        builder.push("general");
        PICKUP_FOOD = builder.comment("If true, villagers will pick up food items from the regardless of mob griefing gamerule. Needed since with mob griefing on they wont be able to breed.").define("pickup_food_override", true);
        EAT_FOOD = builder.comment("If true, villagers will eat food items they pick up. Eating food will heal them").define("eat_food", true);
        TIME_TO_HARVEST = builder.comment("Time for a farmer to harvest a crop once it reached its destination").define("time_to_harvest", 40, 1, 1000);
        DEBUG_RENDERERS = PlatHelper.isDev() ? () -> true : builder.comment("If true, will render debug info for farmers. Only works in single player").define("debug_renderer", false);
        builder.pop();
        builder.buildAndRegister();
    }
}

